/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.io.FunctionalSerialize;
import com.swirlds.common.io.OptionalSelfSerializable;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.SerializableDet;
import com.swirlds.common.io.SerializableWithKnownLength;
import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SerializableDataOutputStream
extends AugmentedDataOutputStream {
    public SerializableDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeProtocolVersion() throws IOException {
        this.writeInt(1);
    }

    private void writeSerializable(SelfSerializable serializable, boolean writeClassId, FunctionalSerialize serializeMethod) throws IOException {
        if (serializable == null) {
            if (writeClassId) {
                this.writeLong(Long.MIN_VALUE);
            } else {
                this.writeInt(Integer.MIN_VALUE);
            }
            return;
        }
        this.writeClassIdVersion(serializable, writeClassId);
        serializeMethod.serialize(this);
    }

    public void writeSerializable(SelfSerializable serializable, boolean writeClassId) throws IOException {
        this.writeSerializable(serializable, writeClassId, serializable);
    }

    public <E extends Enum<E>> void writeOptionalSerializable(OptionalSelfSerializable<E> serializable, boolean writeClassId, E option) throws IOException {
        this.writeSerializable(serializable, writeClassId, out -> serializable.serialize(out, option));
    }

    public <T extends SelfSerializable> void writeSerializableIterableWithSize(Iterator<T> iterator, int size, boolean writeClassId, boolean allSameClass) throws IOException {
        this.writeInt(size);
        if (size == 0) {
            return;
        }
        this.writeBoolean(allSameClass);
        boolean classIdVersionWritten = false;
        while (iterator.hasNext()) {
            SelfSerializable serializable = (SelfSerializable)iterator.next();
            if (!allSameClass) {
                this.writeSerializable(serializable, writeClassId);
                continue;
            }
            if (serializable == null) {
                this.writeBoolean(true);
                continue;
            }
            this.writeBoolean(false);
            if (!classIdVersionWritten) {
                this.writeClassIdVersion(serializable, writeClassId);
                classIdVersionWritten = true;
            }
            serializable.serialize(this);
        }
    }

    public <T extends SelfSerializable> void writeSerializableList(List<T> list, boolean writeClassId, boolean allSameClass) throws IOException {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        this.writeSerializableIterableWithSize(list.iterator(), list.size(), writeClassId, allSameClass);
    }

    public <T extends SelfSerializable> void writeSerializableArray(T[] array, boolean writeClassId, boolean allSameClass) throws IOException {
        if (array == null) {
            this.writeSerializableList(null, writeClassId, allSameClass);
        } else {
            this.writeSerializableList(Arrays.asList(array), writeClassId, allSameClass);
        }
    }

    public static <T extends SerializableWithKnownLength> int getSerializedLength(T[] array, boolean writeClassId, boolean allSameClass) {
        int totalByteLength = 4;
        if (array == null || array.length == 0) {
            return totalByteLength;
        }
        ++totalByteLength;
        boolean classIdVersionWritten = false;
        for (T t : array) {
            if (!allSameClass) {
                totalByteLength += SerializableDataOutputStream.getInstanceSerializedLength(t, true, writeClassId);
                continue;
            }
            if (t == null) {
                ++totalByteLength;
                continue;
            }
            ++totalByteLength;
            if (!classIdVersionWritten) {
                totalByteLength += 4;
                if (writeClassId) {
                    totalByteLength += 8;
                }
                classIdVersionWritten = true;
            }
            totalByteLength += SerializableDataOutputStream.getInstanceSerializedLength(t, false, false);
        }
        return totalByteLength;
    }

    public static <T extends SerializableWithKnownLength> int getInstanceSerializedLength(T data, boolean writeVersion, boolean writeClassId) {
        if (data == null) {
            return writeClassId ? 8 : (writeVersion ? 4 : 0);
        }
        int totalByteLength = 0;
        if (writeClassId) {
            totalByteLength += 8;
        }
        if (writeVersion) {
            totalByteLength += 4;
        }
        return totalByteLength += data.getSerializedLength();
    }

    protected void writeClassIdVersion(SerializableDet serializable, boolean writeClassId) throws IOException {
        if (writeClassId) {
            this.writeLong(serializable.getClassId());
        }
        this.writeInt(serializable.getVersion());
    }
}

