/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.proof.algorithms;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.proof.algorithms.NodeSignature;
import com.swirlds.common.merkle.proof.tree.StateProofInternalNode;
import com.swirlds.common.merkle.proof.tree.StateProofNode;
import com.swirlds.common.merkle.proof.tree.StateProofOpaqueNode;
import com.swirlds.common.merkle.proof.tree.StateProofPayload;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.ByteUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class StateProofTreeBuilder {
    private StateProofTreeBuilder() {
    }

    @NonNull
    public static List<MerkleLeaf> validatePayloads(@NonNull List<MerkleLeaf> payloads) {
        if (payloads.isEmpty()) {
            throw new IllegalArgumentException("payloads must not be empty");
        }
        for (MerkleLeaf leaf : payloads) {
            if (leaf != null) continue;
            throw new IllegalArgumentException("payloads are not permitted to contain null leaves");
        }
        return payloads;
    }

    @NonNull
    public static List<NodeSignature> processSignatures(@NonNull Map<NodeId, Signature> unprocessedSignatures) {
        if (unprocessedSignatures.isEmpty()) {
            throw new IllegalArgumentException("signatures must not be empty");
        }
        ArrayList<NodeSignature> signatures = new ArrayList<NodeSignature>(unprocessedSignatures.size());
        for (Map.Entry<NodeId, Signature> entry : unprocessedSignatures.entrySet()) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("signatures are not permitted to contain null values");
            }
            signatures.add(new NodeSignature(entry.getKey(), entry.getValue()));
        }
        Collections.sort(signatures);
        return signatures;
    }

    private static boolean isAncestorOfPayload(@NonNull MerkleNode potentialAncestor, @NonNull List<MerkleLeaf> payloads) {
        for (MerkleLeaf payload : payloads) {
            if (!potentialAncestor.getRoute().isAncestorOf(payload.getRoute())) continue;
            return true;
        }
        return false;
    }

    private static List<MerkleNode> getMerkleNodesForStateProofTree(@NonNull MerkleNode merkleRoot, @NonNull List<MerkleLeaf> payloads) {
        ArrayList<MerkleNode> nodes = new ArrayList<MerkleNode>();
        merkleRoot.treeIterator().setOrder(MerkleIterationOrder.REVERSE_POST_ORDERED_DEPTH_FIRST).ignoreNull(true).setFilter(node -> StateProofTreeBuilder.isAncestorOfPayload(node, payloads)).setDescendantFilter(node -> StateProofTreeBuilder.isAncestorOfPayload(node, payloads)).forEachRemaining(nodes::add);
        return nodes;
    }

    private static Set<MerkleRoute> getMerkleRouteSet(@NonNull List<MerkleNode> nodes) {
        HashSet<MerkleRoute> routes = new HashSet<MerkleRoute>();
        for (MerkleNode node : nodes) {
            routes.add(node.getRoute());
        }
        return routes;
    }

    private static void validatePayloads(@NonNull List<MerkleNode> nodes, @NonNull Set<MerkleRoute> nodeRoutes, @NonNull List<MerkleLeaf> payloads) {
        for (MerkleLeaf leaf : payloads) {
            if (nodeRoutes.contains(leaf.getRoute())) continue;
            throw new IllegalStateException("Payloads are inconsistent with merkle tree. Payloads contain leaf at " + leaf.getRoute() + " which is not in the merkle tree.");
        }
        int leafCount = 0;
        for (MerkleNode node : nodes) {
            if (!node.isLeaf()) continue;
            ++leafCount;
        }
        if (leafCount != payloads.size()) {
            throw new IllegalStateException("Payloads are inconsistent with merkle tree. Payloads count is " + payloads.size() + " but the node list contains " + leafCount + " leaves.");
        }
    }

    @NonNull
    private static StateProofNode buildStateProofInternalNode(@NonNull Cryptography cryptography, @NonNull MerkleInternal node, @NonNull Set<MerkleRoute> nodeRoutes, @NonNull Deque<StateProofNode> children) {
        ArrayList<StateProofNode> selfChildren = new ArrayList<StateProofNode>();
        ArrayList<byte[]> byteSegments = new ArrayList<byte[]>();
        byteSegments.add(ByteUtils.longToByteArray(Long.reverseBytes(node.getClassId())));
        byteSegments.add(ByteUtils.intToByteArray(Integer.reverseBytes(node.getVersion())));
        for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
            MerkleNode child = node.getChild(childIndex);
            if (child == null) {
                byteSegments.add(cryptography.getNullHash().getValue());
                continue;
            }
            if (nodeRoutes.contains(child.getRoute())) {
                if (!byteSegments.isEmpty()) {
                    selfChildren.add(new StateProofOpaqueNode(byteSegments));
                    byteSegments.clear();
                }
                selfChildren.add(children.pop());
                continue;
            }
            byteSegments.add(child.getHash().getValue());
        }
        if (!byteSegments.isEmpty()) {
            selfChildren.add(new StateProofOpaqueNode(byteSegments));
        }
        return new StateProofInternalNode(selfChildren);
    }

    private static void buildStateProofNode(@NonNull Cryptography cryptography, @NonNull MerkleNode node, @NonNull Set<MerkleRoute> nodeRoutes, @NonNull Deque<StateProofNode> children) {
        if (node.isLeaf()) {
            children.push(new StateProofPayload(node.asLeaf()));
        } else {
            children.push(StateProofTreeBuilder.buildStateProofInternalNode(cryptography, node.asInternal(), nodeRoutes, children));
        }
    }

    @NonNull
    public static StateProofNode buildStateProofTree(@NonNull Cryptography cryptography, @NonNull MerkleNode merkleRoot, @NonNull List<MerkleLeaf> payloads) {
        Objects.requireNonNull(cryptography);
        Objects.requireNonNull(merkleRoot);
        Objects.requireNonNull(payloads);
        List<MerkleNode> nodes = StateProofTreeBuilder.getMerkleNodesForStateProofTree(merkleRoot, payloads);
        Set<MerkleRoute> nodeRoutes = StateProofTreeBuilder.getMerkleRouteSet(nodes);
        StateProofTreeBuilder.validatePayloads(nodes, nodeRoutes, payloads);
        LinkedList<StateProofNode> children = new LinkedList<StateProofNode>();
        for (MerkleNode node : nodes) {
            StateProofTreeBuilder.buildStateProofNode(cryptography, node, nodeRoutes, children);
        }
        if (children.size() != 1) {
            throw new IllegalStateException("State proof tree construction failed. Expected to find just the root node but found " + children.size() + " nodes.");
        }
        return (StateProofNode)children.pop();
    }
}

