/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.proof.algorithms;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.merkle.proof.SignatureVerifier;
import com.swirlds.common.merkle.proof.algorithms.NodeSignature;
import com.swirlds.common.merkle.proof.tree.StateProofInternalNode;
import com.swirlds.common.merkle.proof.tree.StateProofNode;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBook;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class StateProofUtils {
    private StateProofUtils() {
    }

    public static long computeValidSignatureWeight(@NonNull AddressBook addressBook, @NonNull List<NodeSignature> signatures, @NonNull SignatureVerifier signatureVerifier, @NonNull byte[] hashBytes) {
        HashSet<NodeId> signingNodes = new HashSet<NodeId>();
        long validWeight = 0L;
        for (NodeSignature nodeSignature : signatures) {
            Address address;
            if (!signingNodes.add(nodeSignature.nodeId()) || !addressBook.contains(nodeSignature.nodeId()) || (address = addressBook.getAddress(nodeSignature.nodeId())).getWeight() == 0L || !signatureVerifier.verifySignature(nodeSignature.signature(), hashBytes, address.getSigPublicKey())) continue;
            validWeight += address.getWeight();
        }
        return validWeight;
    }

    public static byte[] computeStateProofTreeHash(@NonNull Cryptography cryptography, @NonNull StateProofNode root) {
        MessageDigest digest = DigestType.SHA_384.buildDigest();
        LinkedList<StateProofNode> stack = new LinkedList<StateProofNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            StateProofNode node = (StateProofNode)stack.pop();
            if (node instanceof StateProofInternalNode) {
                StateProofInternalNode internal = (StateProofInternalNode)node;
                if (internal.hasBeenVisited()) {
                    node.computeHashableBytes(cryptography, digest);
                    continue;
                }
                stack.push(node);
                for (int childIndex = internal.getChildren().size() - 1; childIndex >= 0; --childIndex) {
                    stack.push(internal.getChildren().get(childIndex));
                }
                internal.markAsVisited();
                continue;
            }
            node.computeHashableBytes(cryptography, digest);
        }
        return root.getHashableBytes();
    }
}

