/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.internal.Lesson;
import com.swirlds.common.merkle.synchronization.internal.QueryResponse;
import com.swirlds.common.merkle.synchronization.internal.TeacherReceivingThread;
import com.swirlds.common.merkle.synchronization.internal.TeacherSendingThread;
import com.swirlds.common.merkle.synchronization.internal.TeacherSubtree;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeachingSynchronizer {
    private static final String WORK_GROUP_NAME = "teaching-synchronizer";
    private static final Logger logger = LogManager.getLogger(TeachingSynchronizer.class);
    private final MerkleDataInputStream inputStream;
    private final MerkleDataOutputStream outputStream;
    private final Queue<TeacherSubtree> subtrees;
    private final Runnable breakConnection;
    private final ThreadManager threadManager;
    protected final ReconnectConfig reconnectConfig;
    private final Time time;

    public TeachingSynchronizer(@NonNull Time time, @NonNull ThreadManager threadManager, @NonNull MerkleDataInputStream in, @NonNull MerkleDataOutputStream out, @NonNull MerkleNode root, @Nullable Runnable breakConnection, @NonNull ReconnectConfig reconnectConfig) {
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager, "threadManager must not be null");
        this.inputStream = Objects.requireNonNull(in, "in must not be null");
        this.outputStream = Objects.requireNonNull(out, "out must not be null");
        this.subtrees = new LinkedList<TeacherSubtree>();
        this.subtrees.add(new TeacherSubtree(root));
        this.breakConnection = breakConnection;
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig, "reconnectConfig must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void synchronize() throws InterruptedException {
        try {
            while (!this.subtrees.isEmpty()) {
                TeacherSubtree subtree = this.subtrees.remove();
                try {
                    subtree.getView().waitUntilReady();
                    this.sendTree(subtree.getRoot(), subtree.getView());
                }
                finally {
                    if (subtree == null) continue;
                    subtree.close();
                }
            }
            return;
        }
        finally {
            Iterator iterator = this.subtrees.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                TeacherSubtree subtree = (TeacherSubtree)iterator.next();
                subtree.close();
            }
        }
    }

    private <T> void sendTree(MerkleNode root, TeacherTreeView<T> view) throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "sending tree rooted at {} with route {}", (Object)(root == null ? null : root.getClass().getName()), root == null ? "[]" : root.getRoute());
        StandardWorkGroup workGroup = new StandardWorkGroup(this.threadManager, WORK_GROUP_NAME, this.breakConnection, ex -> {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                SocketException socketEx;
                if (!(cause instanceof SocketException) || !(socketEx = (SocketException)cause).getMessage().equalsIgnoreCase("Connection reset by peer")) continue;
                logger.info(LogMarker.RECONNECT.getMarker(), "Connection reset while sending tree at {} with route {}. Aborting", (Object)(root == null ? null : root.getClass().getName()), root == null ? "[]" : root.getRoute());
                return true;
            }
            return false;
        });
        AsyncInputStream<QueryResponse> in = new AsyncInputStream<QueryResponse>(this.inputStream, workGroup, QueryResponse::new, this.reconnectConfig);
        AsyncOutputStream<Lesson<T>> out = this.buildOutputStream(workGroup, this.outputStream);
        in.start();
        out.start();
        AtomicBoolean senderIsFinished = new AtomicBoolean(false);
        new TeacherSendingThread<T>(this.time, this.reconnectConfig, workGroup, in, out, this.subtrees, view, senderIsFinished).start();
        new TeacherReceivingThread<T>(workGroup, in, view, senderIsFinished).start();
        workGroup.waitForTermination();
        if (workGroup.hasExceptions()) {
            throw new MerkleSynchronizationException("Synchronization failed with exceptions");
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "finished sending tree");
    }

    protected <T> AsyncOutputStream<Lesson<T>> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new AsyncOutputStream<Lesson<T>>(out, workGroup, this.reconnectConfig);
    }
}

