/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.internal;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.views.StandardTeacherTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;

public final class TeacherSubtree
implements AutoCloseable {
    private final MerkleNode root;
    private final TeacherTreeView<?> view;

    public TeacherSubtree(MerkleNode root) {
        this(root, new StandardTeacherTreeView(root));
    }

    public TeacherSubtree(MerkleNode root, TeacherTreeView<?> view) {
        this.root = root;
        this.view = view;
        if (root != null) {
            root.reserve();
        }
    }

    public MerkleNode getRoot() {
        return this.root;
    }

    public TeacherTreeView<?> getView() {
        return this.view;
    }

    @Override
    public void close() {
        this.view.close();
        if (this.root != null) {
            this.root.release();
        }
    }
}

