/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricsFactory;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;

public interface IntegerPairAccumulator<T>
extends Metric {
    public static final BiFunction<Integer, Integer, Double> AVERAGE = (sum, count) -> {
        if (count == 0) {
            return 0.0;
        }
        return (double)sum.intValue() / (double)count.intValue();
    };

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    default public T get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public T get();

    public int getLeft();

    public int getRight();

    public void update(int var1, int var2);

    public static final class Config<T>
    extends MetricConfig<IntegerPairAccumulator<T>, Config<T>> {
        private final Class<T> type;
        private final BiFunction<Integer, Integer, T> resultFunction;
        private final IntBinaryOperator leftAccumulator;
        private final IntBinaryOperator rightAccumulator;
        private final IntSupplier leftInitializer;
        private final IntSupplier rightInitializer;
        private static final IntSupplier DEFAULT_INITIALIZER = () -> 0;

        public Config(String category, String name, Class<T> type, BiFunction<Integer, Integer, T> resultFunction) {
            super(category, name, "%s");
            this.type = Objects.requireNonNull(type, "type");
            this.resultFunction = Objects.requireNonNull(resultFunction, "resultFunction");
            this.leftAccumulator = Integer::sum;
            this.rightAccumulator = Integer::sum;
            this.leftInitializer = DEFAULT_INITIALIZER;
            this.rightInitializer = DEFAULT_INITIALIZER;
        }

        private Config(String category, String name, String description, String unit, String format, Class<T> type, BiFunction<Integer, Integer, T> resultFunction, IntBinaryOperator leftAccumulator, IntBinaryOperator rightAccumulator, IntSupplier leftInitializer, IntSupplier rightInitializer) {
            super(category, name, description, unit, format);
            this.type = Objects.requireNonNull(type, "type");
            this.resultFunction = Objects.requireNonNull(resultFunction, "resultFunction");
            this.leftAccumulator = Objects.requireNonNull(leftAccumulator, "leftAccumulator");
            this.rightAccumulator = Objects.requireNonNull(rightAccumulator, "rightAccumulator");
            this.leftInitializer = Objects.requireNonNull(leftInitializer, "leftInitializer");
            this.rightInitializer = Objects.requireNonNull(rightInitializer, "rightInitializer");
        }

        @Override
        public Config<T> withDescription(String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        @Override
        public Config<T> withUnit(String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        public Config<T> withFormat(String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        public Class<T> getType() {
            return this.type;
        }

        public BiFunction<Integer, Integer, T> getResultFunction() {
            return this.resultFunction;
        }

        public IntBinaryOperator getLeftAccumulator() {
            return this.leftAccumulator;
        }

        public Config<T> withLeftAccumulator(IntBinaryOperator leftAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), leftAccumulator, this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        public IntBinaryOperator getRightAccumulator() {
            return this.rightAccumulator;
        }

        public Config<T> withRightAccumulator(IntBinaryOperator rightAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), rightAccumulator, this.getLeftInitializer(), this.getRightInitializer());
        }

        public IntSupplier getLeftInitializer() {
            return this.leftInitializer;
        }

        public Config<T> withLeftInitializer(IntSupplier leftInitializer) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), leftInitializer, this.getRightInitializer());
        }

        public Config<T> withLeftInitialValue(int leftInitialValue) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), leftInitialValue == 0 ? DEFAULT_INITIALIZER : () -> leftInitialValue, this.getRightInitializer());
        }

        public IntSupplier getRightInitializer() {
            return this.rightInitializer;
        }

        public Config<T> withRightInitializer(IntSupplier rightInitializer) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), rightInitializer);
        }

        public Config<T> withRightInitialValue(int rightInitialValue) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), rightInitialValue == 0 ? DEFAULT_INITIALIZER : () -> rightInitialValue);
        }

        @Override
        public Class<IntegerPairAccumulator<T>> getResultClass() {
            return IntegerPairAccumulator.class;
        }

        @Override
        IntegerPairAccumulator<T> create(MetricsFactory factory) {
            return factory.createIntegerPairAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

