/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import java.util.EnumSet;
import java.util.Objects;

public interface LongGauge
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Long get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public long get();

    public void set(long var1);

    public static final class Config
    extends MetricConfig<LongGauge, Config> {
        private final long initialValue;

        public Config(String category, String name) {
            super(category, name, "%d");
            this.initialValue = 0L;
        }

        private Config(String category, String name, String description, String unit, String format, long initialValue) {
            super(category, name, description, unit, format);
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getInitialValue());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getInitialValue());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getInitialValue());
        }

        public long getInitialValue() {
            return this.initialValue;
        }

        public Config withInitialValue(long initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), initialValue);
        }

        @Override
        public Class<LongGauge> getResultClass() {
            return LongGauge.class;
        }

        @Override
        LongGauge create(MetricsFactory factory) {
            return factory.createLongGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

