/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Counter;
import com.swirlds.common.metrics.DoubleAccumulator;
import com.swirlds.common.metrics.DoubleGauge;
import com.swirlds.common.metrics.DurationGauge;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.IntegerAccumulator;
import com.swirlds.common.metrics.IntegerGauge;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.LongAccumulator;
import com.swirlds.common.metrics.LongGauge;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.StatEntry;
import java.util.Objects;

public interface MetricsFactory {
    public Counter createCounter(Counter.Config var1);

    public DoubleAccumulator createDoubleAccumulator(DoubleAccumulator.Config var1);

    public DoubleGauge createDoubleGauge(DoubleGauge.Config var1);

    public DurationGauge createDurationGauge(DurationGauge.Config var1);

    public <T> FunctionGauge<T> createFunctionGauge(FunctionGauge.Config<T> var1);

    public IntegerAccumulator createIntegerAccumulator(IntegerAccumulator.Config var1);

    public IntegerGauge createIntegerGauge(IntegerGauge.Config var1);

    public <T> IntegerPairAccumulator<T> createIntegerPairAccumulator(IntegerPairAccumulator.Config<T> var1);

    public LongAccumulator createLongAccumulator(LongAccumulator.Config var1);

    public LongGauge createLongGauge(LongGauge.Config var1);

    public RunningAverageMetric createRunningAverageMetric(RunningAverageMetric.Config var1);

    public SpeedometerMetric createSpeedometerMetric(SpeedometerMetric.Config var1);

    public StatEntry createStatEntry(StatEntry.Config<?> var1);

    default public <T extends Metric> T createMetric(MetricConfig<T, ?> config) {
        Objects.requireNonNull(config, "config");
        return config.create(this);
    }
}

