/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import java.util.EnumSet;

public interface SpeedometerMetric
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.SPEEDOMETER;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @Override
    public Double get(Metric.ValueType var1);

    public double getHalfLife();

    public void update(double var1);

    public void cycle();

    public double get();

    public static final class Config
    extends MetricConfig<SpeedometerMetric, Config> {
        private final double halfLife;
        private final boolean useDefaultHalfLife;

        public Config(String category, String name) {
            super(category, name, "%,11.3f");
            this.halfLife = -1.0;
            this.useDefaultHalfLife = true;
        }

        private Config(String category, String name, String description, String unit, String format, double halfLife, boolean useDefaultHalfLife) {
            super(category, name, description, unit, format);
            this.halfLife = halfLife;
            this.useDefaultHalfLife = useDefaultHalfLife;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        public boolean isUseDefaultHalfLife() {
            return this.useDefaultHalfLife;
        }

        public Config withHalfLife(double halfLife) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), halfLife, false);
        }

        @Override
        public Class<SpeedometerMetric> getResultClass() {
            return SpeedometerMetric.class;
        }

        @Override
        SpeedometerMetric create(MetricsFactory factory) {
            return factory.createSpeedometerMetric(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).toString();
        }
    }
}

