/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Deprecated(forRemoval=true)
public interface StatEntry
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.STAT_ENTRY;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return this.getBuffered() == null ? EnumSet.of(Metric.ValueType.VALUE) : EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @Override
    default public Object get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (this.getBuffered() == null) {
            if (valueType == Metric.ValueType.VALUE) {
                return this.getStatsStringSupplier().get();
            }
            throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
        }
        return switch (valueType) {
            case Metric.ValueType.VALUE -> this.getStatsStringSupplier().get();
            case Metric.ValueType.MAX -> this.getBuffered().getMax();
            case Metric.ValueType.MIN -> this.getBuffered().getMin();
            case Metric.ValueType.STD_DEV -> this.getBuffered().getStdDev();
            default -> throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
        };
    }

    public StatsBuffered getBuffered();

    public Consumer<Double> getReset();

    public Supplier<Object> getStatsStringSupplier();

    public Supplier<Object> getResetStatsStringSupplier();

    public static final class Config<T>
    extends MetricConfig<StatEntry, Config<T>> {
        private final Class<T> type;
        private final StatsBuffered buffered;
        private final Function<Double, StatsBuffered> init;
        private final Consumer<Double> reset;
        private final Supplier<T> statsStringSupplier;
        private final Supplier<T> resetStatsStringSupplier;
        private final double halfLife;

        public Config(String category, String name, Class<T> type, Supplier<T> statsStringSupplier) {
            super(category, name, "%,11.3f");
            this.type = Objects.requireNonNull(type, "type");
            this.buffered = null;
            this.init = null;
            this.reset = null;
            this.statsStringSupplier = Objects.requireNonNull(statsStringSupplier, "statsStringSupplier");
            this.resetStatsStringSupplier = statsStringSupplier;
            this.halfLife = -1.0;
        }

        private Config(String category, String name, String description, String unit, String format, Class<T> type, StatsBuffered buffered, Function<Double, StatsBuffered> init, Consumer<Double> reset, Supplier<T> statsStringSupplier, Supplier<T> resetStatsStringSupplier, double halfLife) {
            super(category, name, description, unit, format);
            this.type = Objects.requireNonNull(type, "type");
            this.buffered = buffered;
            this.init = init;
            this.reset = reset;
            this.statsStringSupplier = Objects.requireNonNull(statsStringSupplier, "statsStringSupplier");
            this.resetStatsStringSupplier = Objects.requireNonNull(resetStatsStringSupplier, "resetStatsStringSupplier");
            this.halfLife = halfLife;
        }

        @Override
        public Config<T> withDescription(String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        @Override
        public Config<T> withUnit(String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        public Config<T> withFormat(String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        public Class<T> getType() {
            return this.type;
        }

        public StatsBuffered getBuffered() {
            return this.buffered;
        }

        public Config<T> withBuffered(StatsBuffered buffered) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), buffered, this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        public Function<Double, StatsBuffered> getInit() {
            return this.init;
        }

        public Config<T> withInit(Function<Double, StatsBuffered> init) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), init, this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        public Consumer<Double> getReset() {
            return this.reset;
        }

        public Config<T> withReset(Consumer<Double> reset) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), reset, this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), this.getHalfLife());
        }

        public Supplier<T> getStatsStringSupplier() {
            return this.statsStringSupplier;
        }

        public Supplier<T> getResetStatsStringSupplier() {
            return this.resetStatsStringSupplier;
        }

        public Config<T> withResetStatsStringSupplier(Supplier<T> resetStatsStringSupplier) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), resetStatsStringSupplier, this.getHalfLife());
        }

        @Override
        public Class<StatEntry> getResultClass() {
            return StatEntry.class;
        }

        public Config<T> withHalfLife(double halfLife) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getBuffered(), this.getInit(), this.getReset(), this.getStatsStringSupplier(), this.getResetStatsStringSupplier(), halfLife);
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        @Override
        StatEntry create(MetricsFactory factory) {
            return factory.createStatEntry(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

