/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.atomic;

import com.swirlds.common.utility.ByteUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;

public class AtomicIntPair {
    private static final int RESET_VALUE = 0;
    private final AtomicLong container;
    private final LongBinaryOperator operator = (current, supplied) -> {
        int left = leftAccumulator.applyAsInt(ByteUtils.extractLeftInt(current), ByteUtils.extractLeftInt(supplied));
        int right = rightAccumulator.applyAsInt(ByteUtils.extractRightInt(current), ByteUtils.extractRightInt(supplied));
        return ByteUtils.combineInts(left, right);
    };

    public AtomicIntPair() {
        this(Integer::sum, Integer::sum);
    }

    public AtomicIntPair(IntBinaryOperator leftAccumulator, IntBinaryOperator rightAccumulator) {
        this.container = new AtomicLong(0L);
    }

    public void accumulate(int leftValue, int rightValue) {
        this.container.accumulateAndGet(ByteUtils.combineInts(leftValue, rightValue), this.operator);
    }

    public int getLeft() {
        return ByteUtils.extractLeftInt(this.container.get());
    }

    public int getRight() {
        return ByteUtils.extractRightInt(this.container.get());
    }

    public double computeDouble(ToDoubleBiFunction<Integer, Integer> compute) {
        long twoInts = this.container.get();
        return compute.applyAsDouble(ByteUtils.extractLeftInt(twoInts), ByteUtils.extractRightInt(twoInts));
    }

    public double computeDoubleAndReset(ToDoubleBiFunction<Integer, Integer> compute) {
        return this.computeDoubleAndSet(compute, 0, 0);
    }

    public double computeDoubleAndSet(ToDoubleBiFunction<Integer, Integer> compute, int left, int right) {
        long twoInts = this.container.getAndSet(ByteUtils.combineInts(left, right));
        return compute.applyAsDouble(ByteUtils.extractLeftInt(twoInts), ByteUtils.extractRightInt(twoInts));
    }

    public void set(int left, int right) {
        this.container.set(ByteUtils.combineInts(left, right));
    }

    public <T> T compute(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.get();
        return compute.apply(ByteUtils.extractLeftInt(twoInts), ByteUtils.extractRightInt(twoInts));
    }

    public <T> T computeAndReset(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.getAndSet(0L);
        return compute.apply(ByteUtils.extractLeftInt(twoInts), ByteUtils.extractRightInt(twoInts));
    }

    public <T> T computeAndSet(BiFunction<Integer, Integer, T> compute, int left, int right) {
        long twoInts = this.container.getAndSet(ByteUtils.combineInts(left, right));
        return compute.apply(ByteUtils.extractLeftInt(twoInts), ByteUtils.extractRightInt(twoInts));
    }

    public void reset() {
        this.container.getAndSet(0L);
    }
}

