/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.time.IntegerEpochTime;
import com.swirlds.common.utility.ByteUtils;
import com.swirlds.common.utility.StackTrace;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FractionalTimer {
    private static final Logger logger = LogManager.getLogger(FractionalTimer.class);
    private static final int INITIAL_STATUS = -1;
    private static final int OVERFLOW = -1;
    private static final Duration LOG_PERIOD = Duration.ofMinutes(5L);
    private final IntegerEpochTime time;
    private final AtomicLong accumulator;
    private final RateLimitedLogger errorLogger;
    private final LongBinaryOperator activationUpdate;
    private final LongBinaryOperator deactivationUpdate;

    public FractionalTimer(@NonNull Time time) {
        this.time = new IntegerEpochTime(time);
        this.accumulator = new AtomicLong(ByteUtils.combineInts(this.time.getMicroTime(), -1));
        this.errorLogger = new RateLimitedLogger(logger, time, LOG_PERIOD);
        this.activationUpdate = (currentState, now) -> this.statusUpdate(currentState, true, now);
        this.deactivationUpdate = (currentState, now) -> this.statusUpdate(currentState, false, now);
    }

    public void registerMetric(@NonNull Metrics metrics, @NonNull String category, @NonNull String name, @NonNull String description) {
        metrics.getOrCreate(((FunctionGauge.Config)((FunctionGauge.Config)new FunctionGauge.Config<Double>(category, name, Double.class, this::getAndReset).withDescription(description)).withUnit("fraction")).withFormat("%,1.3f"));
    }

    public void activate(long now) {
        this.accumulator.accumulateAndGet(now, this.activationUpdate);
    }

    public void activate() {
        this.activate(this.time.getMicroTime());
    }

    public void deactivate(long now) {
        this.accumulator.accumulateAndGet(now, this.deactivationUpdate);
    }

    public void deactivate() {
        this.deactivate(this.time.getMicroTime());
    }

    public double getActiveFraction() {
        long pair = this.accumulator.get();
        return this.activeFraction(ByteUtils.extractLeftInt(pair), ByteUtils.extractRightInt(pair));
    }

    public double getAndReset() {
        long pair = this.accumulator.getAndUpdate(this::reset);
        return this.activeFraction(ByteUtils.extractLeftInt(pair), ByteUtils.extractRightInt(pair));
    }

    private double activeFraction(int measurementStart, int status) {
        if (measurementStart < 0) {
            return -1.0;
        }
        int elapsedTime = this.time.microsElapsed(measurementStart);
        if (elapsedTime == 0) {
            return 0.0;
        }
        int activeTime = this.isInactive(status) ? Math.abs(status) - 1 : elapsedTime - (status - 1);
        return (double)activeTime / (double)elapsedTime;
    }

    private boolean isInactive(int status) {
        return status < 0;
    }

    private long statusUpdate(long currentState, boolean isBecomingActive, long now) {
        int statusTime;
        int measurementStart = ByteUtils.extractLeftInt(currentState);
        int currentStatus = ByteUtils.extractRightInt(currentState);
        int truncatedTime = (int)now;
        if (isBecomingActive && !this.isInactive(currentStatus) || !isBecomingActive && this.isInactive(currentStatus)) {
            this.errorLogger.error(LogMarker.EXCEPTION.getMarker(), "FractionalTimer has been updated incorrectly. Current status: {}, is becoming active: {}, stack trace: \n{}", currentStatus, isBecomingActive, StackTrace.getStackTrace().toString());
            return currentState;
        }
        int elapsedTime = IntegerEpochTime.elapsed(measurementStart, truncatedTime);
        int newTime = elapsedTime - (statusTime = Math.abs(currentStatus) - 1);
        if (newTime < 0 || measurementStart < 0) {
            return ByteUtils.combineInts(-1, isBecomingActive ? 1 : -1);
        }
        if (isBecomingActive) {
            return ByteUtils.combineInts(measurementStart, newTime + 1);
        }
        return ByteUtils.combineInts(measurementStart, -newTime - 1);
    }

    private long reset(long currentState) {
        return ByteUtils.combineInts(this.time.getMicroTime(), this.resetStatus(ByteUtils.extractRightInt(currentState)));
    }

    private int resetStatus(int status) {
        if (status > 0) {
            return 1;
        }
        return -1;
    }
}

