/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.metrics.extensions.PhaseTimerBuilder;
import com.swirlds.common.time.IntegerEpochTime;
import com.swirlds.common.units.TimeUnit;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PhaseTimer<T extends Enum<T>> {
    private final IntegerEpochTime time;
    private final boolean fractionMetricsEnabled;
    private final boolean absoluteTimeMetricsEnabled;
    private final Map<T, FractionalTimer> fractionalTimers = new HashMap<T, FractionalTimer>();
    private final Map<T, RunningAverageMetric> absoluteTimeMetrics = new HashMap<T, RunningAverageMetric>();
    private T activePhase;
    private long previousTime;
    private final TimeUnit absoluteTimeUnit;

    PhaseTimer(@NonNull PhaseTimerBuilder<T> builder) {
        this.time = new IntegerEpochTime(builder.getTime());
        this.fractionMetricsEnabled = builder.areFractionMetricsEnabled();
        this.absoluteTimeMetricsEnabled = builder.areAbsoluteTimeMetricsEnabled();
        if (this.fractionMetricsEnabled) {
            for (Enum phase : builder.getPhases()) {
                this.fractionalTimers.put(phase, new FractionalTimer(builder.getTime()));
            }
        }
        this.absoluteTimeUnit = builder.getAbsoluteUnit();
        this.registerMetrics(builder.getPlatformContext().getMetrics(), builder.getMetricsCategory(), builder.getMetricsNamePrefix(), builder.getPhases());
        this.activePhase = builder.getInitialPhase();
        this.previousTime = this.time.getMicroTime();
        if (this.fractionMetricsEnabled) {
            this.fractionalTimers.get(this.activePhase).activate();
        }
    }

    public void activatePhase(@NonNull T phase) {
        if (((Enum)phase).equals(this.activePhase)) {
            return;
        }
        long now = this.time.getMicroTime();
        if (this.fractionMetricsEnabled) {
            this.fractionalTimers.get(this.activePhase).deactivate(now);
            this.fractionalTimers.get(phase).activate(now);
        }
        if (this.absoluteTimeMetricsEnabled) {
            long elapsedMicros = now - this.previousTime;
            this.absoluteTimeMetrics.get(this.activePhase).update(TimeUnit.UNIT_MICROSECONDS.convertTo(elapsedMicros, this.absoluteTimeUnit));
        }
        this.previousTime = now;
        this.activePhase = phase;
    }

    private String buildPhaseMetricName(@NonNull String metricsNamePrefix, @NonNull T phase) {
        return metricsNamePrefix + "_fraction_" + phase;
    }

    private String buildAbsoluteTimeMetricName(@NonNull String metricsNamePrefix, @NonNull T phase) {
        return metricsNamePrefix + "_time_" + phase;
    }

    private void registerMetrics(@NonNull Metrics metrics, @NonNull String metricsCategory, @NonNull String metricsNamePrefix, @NonNull Set<T> phases) {
        if (this.fractionMetricsEnabled) {
            for (Enum phase : phases) {
                FractionalTimer timer = this.fractionalTimers.get(phase);
                timer.registerMetric(metrics, metricsCategory, this.buildPhaseMetricName(metricsNamePrefix, phase), "Fraction (out of 1.0) of time spent in phase " + phase.name());
            }
        }
        if (this.absoluteTimeMetricsEnabled) {
            for (Enum phase : phases) {
                RunningAverageMetric.Config config = new RunningAverageMetric.Config(metricsCategory, this.buildAbsoluteTimeMetricName(metricsNamePrefix, phase)).withDescription("Average time spent in phase " + phase.name()).withUnit(this.absoluteTimeUnit.getName());
                RunningAverageMetric metric = metrics.getOrCreate(config);
                this.absoluteTimeMetrics.put(phase, metric);
            }
        }
    }
}

