/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import java.util.List;
import java.util.Objects;

public abstract class AbstractDistributionMetric
extends DefaultMetric {
    protected final double halfLife;

    AbstractDistributionMetric(MetricConfig<?, ?> config, double halfLife) {
        super(config);
        this.halfLife = halfLife;
    }

    public abstract double get();

    public double getHalfLife() {
        return this.halfLife;
    }

    @Override
    public Double get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        return switch (valueType) {
            case Metric.ValueType.VALUE -> this.get();
            case Metric.ValueType.MAX -> this.getStatsBuffered().getMax();
            case Metric.ValueType.MIN -> this.getStatsBuffered().getMin();
            case Metric.ValueType.STD_DEV -> this.getStatsBuffered().getStdDev();
            default -> throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
        };
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        StatsBuffered statsBuffered = this.getStatsBuffered();
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()), new Snapshot.SnapshotEntry(Metric.ValueType.MAX, statsBuffered.getMax()), new Snapshot.SnapshotEntry(Metric.ValueType.MIN, statsBuffered.getMin()), new Snapshot.SnapshotEntry(Metric.ValueType.STD_DEV, statsBuffered.getStdDev()));
    }

    @Override
    public void reset() {
        this.getStatsBuffered().reset(this.halfLife);
    }
}

