/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.DurationGauge;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultDurationGauge
extends DefaultMetric
implements DurationGauge {
    private final AtomicLong nanos;
    private final ChronoUnit unit;

    public DefaultDurationGauge(DurationGauge.Config config) {
        super(config);
        this.unit = config.getTimeUnit();
        this.nanos = new AtomicLong();
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()));
    }

    private double getAsDouble() {
        return this.nanos.get();
    }

    @Override
    public long getNanos() {
        return this.nanos.get();
    }

    @Override
    public void set(Duration duration) {
        if (duration == null) {
            return;
        }
        this.nanos.set(duration.toNanos());
    }

    @Override
    public double get() {
        return this.getAsDouble() / (double)this.unit.getDuration().toNanos();
    }
}

