/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.atomic.AtomicIntPair;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;

public class DefaultIntegerPairAccumulator<T>
extends DefaultMetric
implements IntegerPairAccumulator<T> {
    private final Metric.DataType dataType;
    private final AtomicIntPair container;
    private final BiFunction<Integer, Integer, T> resultFunction;
    private final IntSupplier leftInitializer;
    private final IntSupplier rightInitializer;

    public DefaultIntegerPairAccumulator(IntegerPairAccumulator.Config<T> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.container = new AtomicIntPair(config.getLeftAccumulator(), config.getRightAccumulator());
        this.resultFunction = config.getResultFunction();
        this.leftInitializer = config.getLeftInitializer();
        this.rightInitializer = config.getRightInitializer();
        this.container.set(this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
    }

    @Override
    public MetricType getMetricType() {
        return MetricType.ACCUMULATOR;
    }

    @Override
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        T result = this.container.computeAndSet(this.resultFunction, this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, result));
    }

    @Override
    public T get() {
        return this.container.compute(this.resultFunction);
    }

    @Override
    public void reset() {
        this.container.set(this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
    }

    @Override
    public int getLeft() {
        return this.container.getLeft();
    }

    @Override
    public int getRight() {
        return this.container.getRight();
    }

    @Override
    public void update(int leftValue, int rightValue) {
        this.container.accumulate(leftValue, rightValue);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.get()).toString();
    }
}

