/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.LongAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;

public class DefaultLongAccumulator
extends DefaultMetric
implements LongAccumulator {
    private final AtomicLong container;
    private final LongBinaryOperator accumulator;
    private final LongSupplier initializer;

    public DefaultLongAccumulator(LongAccumulator.Config config) {
        super(config);
        long initialValue = config.getInitialValue();
        LongSupplier configInitializer = config.getInitializer();
        this.accumulator = config.getAccumulator();
        this.initializer = configInitializer != null ? configInitializer : () -> initialValue;
        this.container = new AtomicLong(this.initializer.getAsLong());
    }

    @Override
    public long getInitialValue() {
        return this.initializer.getAsLong();
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.container.getAndSet(this.initializer.getAsLong())));
    }

    @Override
    public long get() {
        return this.container.get();
    }

    @Override
    public void update(long other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsLong());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

