/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.utility.CommonUtils;
import java.util.List;

public record Snapshot(Metric metric, List<SnapshotEntry> entries) {
    public static Snapshot of(DefaultMetric metric) {
        CommonUtils.throwArgNull(metric, "metric");
        return new Snapshot(metric, metric.takeSnapshot());
    }

    public Object getValue() {
        for (SnapshotEntry entry : this.entries) {
            if (entry.valueType != Metric.ValueType.VALUE) continue;
            return entry.value;
        }
        throw new IllegalStateException("Snapshot does not contain a value: " + this);
    }

    public record SnapshotEntry(Metric.ValueType valueType, Object value) {
    }
}

