/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.state.Startable;
import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.DefaultMetrics;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.platform.SnapshotEvent;
import com.swirlds.common.utility.CommonUtils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnapshotService
implements Startable {
    private static final Logger logger = LogManager.getLogger(SnapshotService.class);
    private final DefaultMetrics globalMetrics;
    private final Queue<DefaultMetrics> platformMetricsList = new ConcurrentLinkedQueue<DefaultMetrics>();
    private final ScheduledExecutorService executor;
    private final Queue<Consumer<? super SnapshotEvent>> subscribers = new ConcurrentLinkedQueue<Consumer<? super SnapshotEvent>>();
    private final AtomicBoolean running = new AtomicBoolean();
    private final Time time;
    private final long delayNanos;

    public SnapshotService(DefaultMetrics globalMetrics, ScheduledExecutorService executor, Duration interval) {
        this(globalMetrics, executor, interval, Time.getCurrent());
    }

    public SnapshotService(DefaultMetrics globalMetrics, ScheduledExecutorService executor, Duration interval, Time time) {
        this.globalMetrics = CommonUtils.throwArgNull(globalMetrics, "globalMetrics");
        if (!globalMetrics.isGlobalMetrics()) {
            throw new IllegalArgumentException("Trying to create SnapshotService with non-global Metrics");
        }
        this.executor = CommonUtils.throwArgNull(executor, "executor");
        this.delayNanos = CommonUtils.throwArgNull(interval, "interval").toNanos();
        this.time = CommonUtils.throwArgNull(time, "time");
        logger.debug("SnapshotService initialized");
    }

    public void addPlatformMetric(DefaultMetrics platformMetrics) {
        CommonUtils.throwArgNull(platformMetrics, "platformMetric");
        if (!platformMetrics.isPlatformMetrics()) {
            throw new IllegalArgumentException("Trying to add non-platform Metrics");
        }
        logger.debug("Adding platform Metrics {}", (Object)platformMetrics);
        this.platformMetricsList.add(platformMetrics);
    }

    public void removePlatformMetric(DefaultMetrics platformMetrics) {
        CommonUtils.throwArgNull(platformMetrics, "platformMetric");
        if (!platformMetrics.isPlatformMetrics()) {
            throw new IllegalArgumentException("Trying to remove non-platform Metrics");
        }
        logger.debug("Removing platform Metrics {}", (Object)platformMetrics);
        this.platformMetricsList.remove(platformMetrics);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("The snapshot-service is already running");
        }
        logger.debug("Starting SnapshotService");
        this.executor.schedule(this::mainLoop, this.delayNanos, TimeUnit.NANOSECONDS);
    }

    public void shutdown() {
        logger.debug("Shutting down snapshotService");
        this.running.set(false);
        this.executor.shutdown();
    }

    public Runnable subscribe(Consumer<? super SnapshotEvent> subscriber) {
        this.subscribers.add(subscriber);
        return () -> this.subscribers.remove(subscriber);
    }

    private void mainLoop() {
        if (!this.isRunning()) {
            return;
        }
        logger.trace("Running mainLoop");
        long start = this.time.nanoTime();
        Map globalSnapshots = this.globalMetrics.getAll().stream().map(DefaultMetric.class::cast).map(Snapshot::of).collect(Collectors.toMap(snapshot -> DefaultMetrics.calculateMetricKey(snapshot.metric()), Function.identity()));
        logger.trace(() -> String.format("Created %d global snapshots", globalSnapshots.size()));
        SnapshotEvent globalEvent = new SnapshotEvent(null, globalSnapshots.values());
        this.subscribers.forEach(subscriber -> subscriber.accept(globalEvent));
        for (DefaultMetrics platformMetrics : this.platformMetricsList) {
            List<Snapshot> platformSnapshots = platformMetrics.getAll().stream().map(metric -> globalSnapshots.getOrDefault(DefaultMetrics.calculateMetricKey(metric), Snapshot.of((DefaultMetric)metric))).toList();
            logger.trace(() -> String.format("Created %d snapshots for node %s", platformSnapshots.size(), platformMetrics.getNodeId()));
            SnapshotEvent platformEvent = new SnapshotEvent(platformMetrics.getNodeId(), platformSnapshots);
            this.subscribers.forEach(subscriber -> subscriber.accept(platformEvent));
        }
        long delta = this.time.nanoTime() - start;
        logger.trace("Running mainLoop took {} ns", (Object)delta);
        try {
            this.executor.schedule(this::mainLoop, Math.max(0L, this.delayNanos - delta), TimeUnit.NANOSECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

