/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform.prometheus;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.platform.prometheus.AbstractMetricAdapter;
import com.swirlds.common.metrics.platform.prometheus.NameConverter;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.CommonUtils;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;

public class CounterAdapter
extends AbstractMetricAdapter {
    private final Counter counter;

    public CounterAdapter(CollectorRegistry registry, Metric metric, PrometheusEndpoint.AdapterType adapterType) {
        super(adapterType);
        CommonUtils.throwArgNull(registry, "registry");
        CommonUtils.throwArgNull(metric, "metric");
        Counter.Builder builder = ((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)new Counter.Builder().subsystem(NameConverter.fix(metric.getCategory()))).name(NameConverter.fix(metric.getName()))).help(metric.getDescription())).unit(metric.getUnit())).withoutExemplars();
        if (adapterType == PrometheusEndpoint.AdapterType.PLATFORM) {
            builder.labelNames(new String[]{"node"});
        }
        this.counter = (Counter)builder.register(registry);
    }

    @Override
    public void update(Snapshot snapshot, NodeId nodeId) {
        CommonUtils.throwArgNull(snapshot, "snapshot");
        double newValue = ((Number)snapshot.getValue()).doubleValue();
        if (this.adapterType == PrometheusEndpoint.AdapterType.GLOBAL) {
            double oldValue = this.counter.get();
            this.counter.inc(newValue - oldValue);
        } else {
            CommonUtils.throwArgNull(nodeId, "nodeId");
            Counter.Child child = (Counter.Child)this.counter.labels(new String[]{nodeId.toString()});
            double oldValue = child.get();
            child.inc(newValue - oldValue);
        }
    }

    @Override
    public void unregister(CollectorRegistry registry) {
        registry.unregister((Collector)this.counter);
    }
}

