/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.sequence.map.internal;

import com.swirlds.common.sequence.map.SequenceMap;
import com.swirlds.common.sequence.map.internal.SequenceKeySet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;

public abstract class AbstractSequenceMap<K, V>
implements SequenceMap<K, V> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final Map<K, V> data;
    private SequenceKeySet<K>[] keySets;
    private int sequenceNumberCapacity;
    private final ToLongFunction<K> getSequenceNumberFromKey;
    private final long initialFirstSequenceNumber;
    private final boolean allowExpansion;

    protected AbstractSequenceMap(long initialFirstSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<K> getSequenceNumberFromKey) {
        this.initialFirstSequenceNumber = initialFirstSequenceNumber;
        this.sequenceNumberCapacity = sequenceNumberCapacity;
        this.allowExpansion = allowExpansion;
        this.getSequenceNumberFromKey = Objects.requireNonNull(getSequenceNumberFromKey);
        this.data = this.buildDataMap();
        this.keySets = new SequenceKeySet[sequenceNumberCapacity];
        for (long sequenceNumber = initialFirstSequenceNumber; sequenceNumber < initialFirstSequenceNumber + (long)sequenceNumberCapacity; ++sequenceNumber) {
            this.keySets[this.getSequenceKeyIndex((long)sequenceNumber)] = new SequenceKeySet(sequenceNumber);
        }
    }

    protected abstract void setFirstSequenceNumberInWindow(long var1);

    protected abstract Map<K, V> buildDataMap();

    protected void windowLock() {
    }

    protected void windowUnlock() {
    }

    protected void lockSequenceNumber(long sequenceNumber) {
    }

    protected void unlockSequenceNumber(long sequenceNumber) {
    }

    protected void fullLock() {
    }

    protected void fullUnlock() {
    }

    protected int getFullLockThreshold() {
        return 0;
    }

    @Override
    public V get(K key) {
        return this.data.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    @Override
    public int getSequenceNumberCapacity() {
        return this.sequenceNumberCapacity;
    }

    private long getSequenceNumber(K key) {
        return this.getSequenceNumberFromKey.applyAsLong(key);
    }

    private int getSequenceKeyIndex(long sequenceNumber) {
        if (sequenceNumber >= 0L) {
            return (int)(sequenceNumber % (long)this.sequenceNumberCapacity);
        }
        return (int)((sequenceNumber % (long)this.sequenceNumberCapacity + (long)this.sequenceNumberCapacity) % (long)this.sequenceNumberCapacity);
    }

    private SequenceKeySet<K> getSequenceKeySet(long sequenceNumber) {
        return this.keySets[this.getSequenceKeyIndex(sequenceNumber)];
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        boolean added;
        V value = this.data.get(key);
        if (value == null && !(added = this.putIfAbsent(key, value = mappingFunction.apply(key)))) {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        long sequenceNumber = this.getSequenceNumber(key);
        SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
        this.lockSequenceNumber(sequenceNumber);
        try {
            if (keys.getSequenceNumber() != sequenceNumber) {
                if (this.allowExpansion && sequenceNumber > this.getFirstSequenceNumberInWindow()) {
                    this.expandCapacity(sequenceNumber);
                    keys = this.getSequenceKeySet(sequenceNumber);
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.data.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            this.data.put(key, value);
            keys.getKeys().add(key);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockSequenceNumber(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        long sequenceNumber = this.getSequenceNumber(key);
        SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
        this.lockSequenceNumber(sequenceNumber);
        try {
            if (keys.getSequenceNumber() != sequenceNumber) {
                if (this.allowExpansion && sequenceNumber > this.getFirstSequenceNumberInWindow()) {
                    this.expandCapacity(sequenceNumber);
                    keys = this.getSequenceKeySet(sequenceNumber);
                } else {
                    V v = null;
                    return v;
                }
            }
            V previousValue = this.data.put(key, value);
            keys.getKeys().add(key);
            V v = previousValue;
            return v;
        }
        finally {
            this.unlockSequenceNumber(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        long sequenceNumber = this.getSequenceNumber(key);
        SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
        this.lockSequenceNumber(sequenceNumber);
        try {
            if (keys.getSequenceNumber() != sequenceNumber) {
                V v = null;
                return v;
            }
            keys.getKeys().remove(key);
            V v = this.data.remove(key);
            return v;
        }
        finally {
            this.unlockSequenceNumber(sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shiftWindow(long firstSequenceNumberInWindow, BiConsumer<K, V> removedValueHandler) {
        boolean largeShift;
        this.windowLock();
        long shiftSize = firstSequenceNumberInWindow - this.getFirstSequenceNumberInWindow();
        boolean bl = largeShift = shiftSize >= (long)this.getFullLockThreshold();
        if (largeShift) {
            this.fullLock();
        }
        try {
            long previousFirstSequenceNumber = this.getFirstSequenceNumberInWindow();
            if (firstSequenceNumberInWindow < previousFirstSequenceNumber) {
                throw new IllegalStateException("Window can only be shifted towards larger value. Current lowest sequence number = " + previousFirstSequenceNumber + ", requested lowest sequence number = " + firstSequenceNumberInWindow);
            }
            this.setFirstSequenceNumberInWindow(firstSequenceNumberInWindow);
            for (int offset = 0; offset < this.sequenceNumberCapacity; ++offset) {
                long sequenceNumberToReplace = previousFirstSequenceNumber + (long)offset;
                if (sequenceNumberToReplace >= firstSequenceNumberInWindow) {
                    return;
                }
                SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumberToReplace);
                if (!largeShift) {
                    this.lockSequenceNumber(sequenceNumberToReplace);
                }
                try {
                    for (K key : keys.getKeys()) {
                        V value = this.data.remove(key);
                        if (removedValueHandler == null) continue;
                        removedValueHandler.accept(key, value);
                    }
                    keys.setSequenceNumber(this.mapToNewSequenceNumber(firstSequenceNumberInWindow, sequenceNumberToReplace));
                    keys.getKeys().clear();
                    continue;
                }
                finally {
                    if (!largeShift) {
                        this.unlockSequenceNumber(sequenceNumberToReplace);
                    }
                }
            }
        }
        finally {
            this.windowUnlock();
            if (largeShift) {
                this.fullUnlock();
            }
        }
    }

    private long mapToNewSequenceNumber(long firstSequenceNumberInWindow, long sequenceNumberToReplace) {
        long difference = firstSequenceNumberInWindow - sequenceNumberToReplace;
        long wrapFactor = difference / (long)this.getSequenceNumberCapacity() + (long)(difference % (long)this.getSequenceNumberCapacity() == 0L ? 0 : 1);
        long increase = wrapFactor * (long)this.getSequenceNumberCapacity();
        return sequenceNumberToReplace + increase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandCapacity(long requiredSequenceNumber) {
        this.windowLock();
        this.fullLock();
        try {
            int oldCapacity = this.keySets.length;
            long firstSequenceNumber = this.getFirstSequenceNumberInWindow();
            long minimumCapacity = requiredSequenceNumber - firstSequenceNumber;
            if (minimumCapacity < 0L) {
                throw new IllegalStateException("Cannot expand capacity beyond 2147483639");
            }
            if (minimumCapacity < 0x3FFFFFFAL) {
                this.sequenceNumberCapacity = (int)(minimumCapacity * 2L);
            } else if (minimumCapacity <= 0x7FFFFFF7L) {
                this.sequenceNumberCapacity = 0x7FFFFFF7;
            } else {
                throw new IllegalStateException("Cannot expand capacity beyond 2147483639");
            }
            SequenceKeySet<K>[] oldKeySets = this.keySets;
            this.keySets = new SequenceKeySet[this.sequenceNumberCapacity];
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                long sequenceNumber = oldKeySets[oldIndex].getSequenceNumber();
                int newIndex = this.getSequenceKeyIndex(sequenceNumber);
                this.keySets[newIndex] = oldKeySets[oldIndex];
            }
            for (int offset = 0; offset < this.sequenceNumberCapacity - oldCapacity; ++offset) {
                long newSequenceNumber = firstSequenceNumber + (long)oldCapacity + (long)offset;
                int index = this.getSequenceKeyIndex(newSequenceNumber);
                this.keySets[index] = new SequenceKeySet(newSequenceNumber);
            }
        }
        finally {
            this.fullUnlock();
            this.windowUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValuesWithSequenceNumber(long sequenceNumber, BiConsumer<K, V> removedValueHandler) {
        this.windowLock();
        try {
            SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
            this.lockSequenceNumber(sequenceNumber);
            try {
                if (keys.getSequenceNumber() != sequenceNumber) {
                    return;
                }
                for (K key : keys.getKeys()) {
                    V value = this.data.remove(key);
                    if (removedValueHandler == null) continue;
                    removedValueHandler.accept(key, value);
                }
                keys.getKeys().clear();
            }
            finally {
                this.unlockSequenceNumber(sequenceNumber);
            }
        }
        finally {
            this.windowUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<K> getKeysWithSequenceNumber(long sequenceNumber) {
        LinkedList<K> list = new LinkedList<K>();
        SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
        this.lockSequenceNumber(sequenceNumber);
        try {
            if (keys.getSequenceNumber() == sequenceNumber) {
                list.addAll(keys.getKeys());
            }
        }
        finally {
            this.unlockSequenceNumber(sequenceNumber);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<K, V>> getEntriesWithSequenceNumber(long sequenceNumber) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>();
        SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
        this.lockSequenceNumber(sequenceNumber);
        try {
            if (keys.getSequenceNumber() == sequenceNumber) {
                for (K key : keys.getKeys()) {
                    list.add(new AbstractMap.SimpleEntry<K, V>(key, this.data.get(key)));
                }
            }
        }
        finally {
            this.unlockSequenceNumber(sequenceNumber);
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.windowLock();
        this.fullLock();
        try {
            this.data.clear();
            this.setFirstSequenceNumberInWindow(this.initialFirstSequenceNumber);
            for (int offset = 0; offset < this.sequenceNumberCapacity; ++offset) {
                long sequenceNumber = this.initialFirstSequenceNumber + (long)offset;
                SequenceKeySet<K> keys = this.getSequenceKeySet(sequenceNumber);
                keys.setSequenceNumber(sequenceNumber);
                keys.getKeys().clear();
            }
        }
        finally {
            this.windowUnlock();
            this.fullUnlock();
        }
    }
}

