/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.logging.LogMarker;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiStream<T extends RunningHashable>
implements LinkedObjectStream<T> {
    private static final Logger logger = LogManager.getLogger(MultiStream.class);
    public static final String NEXT_STREAM_NULL = "MultiStream should not have null nextStream";
    private static final int NEXT_STREAMS_MIN_SIZE = 1;
    public static final String NOT_ENOUGH_NEXT_STREAMS = String.format("MultiStream should have at least %d nextStreams", 1);
    private List<LinkedObjectStream<T>> nextStreams;

    public MultiStream(List<LinkedObjectStream<T>> nextStreams) {
        if (nextStreams == null || nextStreams.size() < 1) {
            throw new IllegalArgumentException(NOT_ENOUGH_NEXT_STREAMS);
        }
        for (LinkedObjectStream<T> nextStream : nextStreams) {
            if (nextStream != null) continue;
            throw new IllegalArgumentException(NEXT_STREAM_NULL);
        }
        this.nextStreams = nextStreams;
    }

    @Override
    public void setRunningHash(Hash hash) {
        for (LinkedObjectStream<T> nextStream : this.nextStreams) {
            nextStream.setRunningHash(hash);
        }
    }

    @Override
    public void addObject(T t) {
        for (LinkedObjectStream<T> nextStream : this.nextStreams) {
            nextStream.addObject(t);
        }
    }

    @Override
    public void clear() {
        for (LinkedObjectStream<T> nextStream : this.nextStreams) {
            nextStream.clear();
        }
    }

    @Override
    public void close() {
        for (LinkedObjectStream<T> nextStream : this.nextStreams) {
            nextStream.close();
        }
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "MultiStream is closed");
    }
}

