/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.CryptographyHolder;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.stream.internal.AbstractLinkedObjectStream;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.logging.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunningHashCalculatorForStream<T extends RunningHashable & SerializableHashable>
extends AbstractLinkedObjectStream<T> {
    private static final Logger logger = LogManager.getLogger(RunningHashCalculatorForStream.class);
    private final Cryptography cryptography;
    private Hash runningHash;

    public RunningHashCalculatorForStream() {
        this.cryptography = CryptographyHolder.get();
    }

    public RunningHashCalculatorForStream(LinkedObjectStream<T> nextStream) {
        super(nextStream);
        this.cryptography = CryptographyHolder.get();
    }

    public RunningHashCalculatorForStream(Cryptography cryptography) {
        this.cryptography = cryptography;
    }

    public RunningHashCalculatorForStream(LinkedObjectStream<T> nextStream, Cryptography cryptography) {
        super(nextStream);
        this.cryptography = cryptography;
    }

    @Override
    public void addObject(T t) {
        if (((SerializableHashable)t).getHash() == null) {
            this.cryptography.digestSync((SerializableHashable)t);
        }
        Hash newHashToAdd = ((SerializableHashable)t).getHash();
        this.runningHash = this.cryptography.calcRunningHash(this.runningHash, newHashToAdd, DigestType.SHA_384);
        t.getRunningHash().setHash(this.runningHash);
        super.addObject(t);
    }

    @Override
    public void close() {
        super.close();
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream is closed");
    }

    public Hash getRunningHash() {
        return this.runningHash;
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.runningHash = hash;
        super.setRunningHash(hash);
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream :: setRunningHash: {}", (Object)hash);
    }
}

