/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream.internal;

import com.swirlds.base.utility.Pair;
import com.swirlds.common.crypto.CryptographyHolder;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.InvalidStreamFileException;
import com.swirlds.common.stream.internal.StreamValidationResult;
import com.swirlds.logging.LogMarker;
import com.swirlds.logging.payloads.StreamParseErrorPayload;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LinkedObjectStreamValidateUtils {
    private static final Logger logger = LogManager.getLogger(LinkedObjectStreamValidateUtils.class);

    private LinkedObjectStreamValidateUtils() {
    }

    public static StreamValidationResult validateFileAndSignature(File streamFile, File sigFile, PublicKey publicKey, StreamType streamType) {
        StreamValidationResult result;
        try {
            Pair<StreamValidationResult, Hash> objectResult = LinkedObjectStreamValidateUtils.validateDirOrFile(streamFile, streamType);
            if (objectResult.left() != StreamValidationResult.OK) {
                return (StreamValidationResult)((Object)objectResult.left());
            }
            Hash entireHash = LinkedObjectStreamUtilities.computeEntireHash(streamFile);
            result = LinkedObjectStreamValidateUtils.validateSignature(entireHash, sigFile, publicKey, streamType);
        }
        catch (InvalidStreamFileException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("validateFileAndSignature : failed to validate file %s", streamFile.getName())), (Throwable)ex);
            result = StreamValidationResult.PARSE_STREAM_FILE_FAIL;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("validateFileAndSignature : failed to calculate entireHash for %s", streamFile.getName())), (Throwable)ex);
            result = StreamValidationResult.FAIL_TO_CALCULATE_ENTIRE_HASH;
        }
        return result;
    }

    public static StreamValidationResult validateSignature(Hash entireHash, File sigFile, PublicKey publicKey, StreamType streamType) {
        StreamValidationResult result;
        Pair<Pair<Hash, Signature>, Pair<Hash, Signature>> parsedPairs;
        try {
            parsedPairs = LinkedObjectStreamUtilities.parseSigFile(sigFile, streamType);
        }
        catch (InvalidStreamFileException | IOException | IllegalArgumentException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new StreamParseErrorPayload(String.format("parseSigFile : fail to read signature from File %s", sigFile.getName())), (Throwable)ex);
            return StreamValidationResult.PARSE_SIG_FILE_FAIL;
        }
        Hash entireHashInSig = (Hash)((Pair)parsedPairs.left()).left();
        if (!entireHash.equals(entireHashInSig)) {
            result = StreamValidationResult.SIG_HASH_NOT_MATCH_FILE;
        } else {
            Signature entireSignature = (Signature)((Pair)parsedPairs.left()).right();
            Hash metaHashInSig = (Hash)((Pair)parsedPairs.right()).left();
            Signature metaSignature = (Signature)((Pair)parsedPairs.right()).right();
            result = !entireSignature.verifySignature(entireHash.getValue(), publicKey) ? StreamValidationResult.INVALID_ENTIRE_SIGNATURE : (!metaSignature.verifySignature(metaHashInSig.getValue(), publicKey) ? StreamValidationResult.INVALID_META_SIGNATURE : StreamValidationResult.OK);
        }
        return result;
    }

    public static Pair<StreamValidationResult, Hash> validateDirOrFile(File objectDirOrFile, StreamType streamType) throws InvalidStreamFileException {
        return LinkedObjectStreamValidateUtils.validateIterator(LinkedObjectStreamUtilities.parseStreamDirOrFile(objectDirOrFile, streamType));
    }

    public static Pair<StreamValidationResult, Hash> validateFileList(List<File> fileList, StreamType streamType) {
        return LinkedObjectStreamValidateUtils.validateIterator(LinkedObjectStreamUtilities.parseStreamFileList(fileList, streamType));
    }

    public static <T extends SelfSerializable> Pair<StreamValidationResult, Hash> validateIterator(Iterator<T> iterator) {
        if (iterator == null) {
            return Pair.of((Object)((Object)StreamValidationResult.PARSE_STREAM_FILE_FAIL), null);
        }
        if (!iterator.hasNext()) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_EMPTY), null);
        }
        SelfSerializable first = (SelfSerializable)iterator.next();
        if (!(first instanceof Hash)) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_START_HASH), null);
        }
        Hash runningHash = (Hash)first;
        SelfSerializable selfSerializable = null;
        int objectsCount = 0;
        while (iterator.hasNext()) {
            selfSerializable = (SelfSerializable)iterator.next();
            if (!iterator.hasNext() && selfSerializable instanceof Hash) break;
            ++objectsCount;
            Hash objectHash = CryptographyHolder.get().digestSync(selfSerializable);
            runningHash = CryptographyHolder.get().calcRunningHash(runningHash, objectHash, DigestType.SHA_384);
            logger.info(LogMarker.OBJECT_STREAM.getMarker(), "validateIterator :: after consuming object {},hash: {}, updated runningHash: {}", (Object)selfSerializable, (Object)objectHash, (Object)runningHash);
        }
        if (objectsCount == 0) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_OBJECTS), null);
        }
        if (!(selfSerializable instanceof Hash)) {
            return Pair.of((Object)((Object)StreamValidationResult.STREAM_FILE_MISS_END_HASH), null);
        }
        Hash endHash = (Hash)selfSerializable;
        if (!runningHash.equals(endHash)) {
            logger.info(LogMarker.EXCEPTION.getMarker(), "calculated: {}, read: {}", (Object)runningHash, (Object)endHash);
            return Pair.of((Object)((Object)StreamValidationResult.CALCULATED_END_HASH_NOT_MATCH), (Object)endHash);
        }
        return Pair.of((Object)((Object)StreamValidationResult.OK), (Object)endHash);
    }
}

