/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream.internal;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashingOutputStream;
import com.swirlds.common.crypto.RunningHash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import com.swirlds.common.stream.Signer;
import com.swirlds.common.stream.StreamAligned;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.Timestamped;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.threading.futures.StandardFuture;
import com.swirlds.logging.LogMarker;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class TimestampStreamFileWriter<T extends StreamAligned & RunningHashable & Timestamped>
implements LinkedObjectStream<T> {
    public static final int OBJECT_STREAM_VERSION = 1;
    public static final int OBJECT_STREAM_SIG_VERSION = 1;
    private static final Logger logger = LogManager.getLogger(TimestampStreamFileWriter.class);
    private static final SignatureType SIGNATURE_TYPE = SignatureType.RSA;
    private final StreamType streamType;
    private final String directory;
    private final Signer signer;
    private final long windowSizeMs;
    private final MessageDigest streamDigest;
    private final MessageDigest metadataStreamDigest;
    private FileOutputStream fileStream = null;
    private SerializableDataOutputStream out = null;
    private SerializableDataOutputStream metadataOut = null;
    private File currentFile;
    private RunningHash runningHash;
    private T previousObject;
    private boolean previousHeldBackByAlignment;
    private boolean startWriteAtCompleteWindow;

    public TimestampStreamFileWriter(String directory, long windowSizeMs, Signer signer, boolean startWriteAtCompleteWindow, StreamType streamType) {
        this.directory = directory;
        this.windowSizeMs = windowSizeMs;
        this.signer = signer;
        this.startWriteAtCompleteWindow = startWriteAtCompleteWindow;
        this.streamType = streamType;
        try {
            this.streamDigest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            this.metadataStreamDigest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSignatureFile(Hash entireHash, Signature entireSignature, Hash metaHash, Signature metaSignature, String sigFilePath, StreamType streamType) throws IOException {
        try (SerializableDataOutputStream output = new SerializableDataOutputStream(new BufferedOutputStream(new FileOutputStream(sigFilePath)));){
            for (byte num : streamType.getSigFileHeader()) {
                output.writeByte(num);
            }
            output.writeInt(1);
            output.writeSerializable(entireHash, true);
            output.writeSerializable(entireSignature, true);
            output.writeSerializable(metaHash, true);
            output.writeSerializable(metaSignature, true);
            logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "signature file saved: {}", (Object)sigFilePath);
        }
    }

    private void serialize(T object) {
        try {
            this.out.writeSerializable((SelfSerializable)object, true);
            this.out.flush();
        }
        catch (IOException e) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "IOException when serializing {}", object, (Object)e);
        }
    }

    private void startNewFile(T object) {
        this.currentFile = new File(this.generateStreamFilePath(object));
        try {
            if (this.currentFile.exists() && !this.currentFile.isDirectory()) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = this.currentFile::getName;
                logger.info(LogMarker.OBJECT_STREAM.getMarker(), "Stream file already exists {}", supplierArray);
            } else {
                this.fileStream = new FileOutputStream(this.currentFile, false);
                this.out = new SerializableDataOutputStream(new BufferedOutputStream(new HashingOutputStream(this.streamDigest, this.fileStream)));
                this.metadataOut = new SerializableDataOutputStream(new HashingOutputStream(this.metadataStreamDigest));
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = this.currentFile::getName;
                logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "Stream file created {}", supplierArray);
            }
        }
        catch (FileNotFoundException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "startNewFile :: FileNotFound: ", (Throwable)e);
        }
    }

    private void begin() {
        try {
            for (int num : this.streamType.getFileHeader()) {
                this.out.writeInt(num);
                this.metadataOut.writeInt(num);
            }
            this.out.writeInt(1);
            this.metadataOut.writeInt(1);
            logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "begin :: write OBJECT_STREAM_VERSION {}", (Object)1);
            Hash startRunningHash = (Hash)((StandardFuture)this.runningHash.getFutureHash()).getAndRethrow();
            this.out.writeSerializable(startRunningHash, true);
            this.metadataOut.writeSerializable(startRunningHash, true);
            logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "begin :: write startRunningHash {}", (Object)startRunningHash);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "begin :: Got IOException when writing startRunningHash to {}", (Object)this.currentFile.getName(), (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(LogMarker.EXCEPTION.getMarker(), "begin :: Got interrupted when getting startRunningHash for writing {}", (Object)this.currentFile.getName(), (Object)e);
        }
    }

    public void closeCurrentAndSign() {
        if (this.fileStream != null) {
            try {
                Hash finalRunningHash = (Hash)((StandardFuture)this.runningHash.getFutureHash()).getAndRethrow();
                this.out.writeSerializable(finalRunningHash, true);
                this.metadataOut.writeSerializable(finalRunningHash, true);
                logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "closeCurrentAndSign {} :: write endRunningHash {}", (Object)this.currentFile, (Object)finalRunningHash);
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign :: Got Exception when writing endRunningHash to {}", (Object)this.currentFile.getName(), (Object)e);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign :: Got interrupted when getting endRunningHash for writing {}", (Object)this.currentFile.getName(), (Object)e);
                return;
            }
            File closedFile = this.currentFile;
            this.closeFile();
            Hash entireHash = new Hash(this.streamDigest.digest(), DigestType.SHA_384);
            Hash metaHash = new Hash(this.metadataStreamDigest.digest(), DigestType.SHA_384);
            Signature entireSignature = new Signature(SIGNATURE_TYPE, this.signer.sign(entireHash.getValue()).getSignatureBytes());
            Signature metaSignature = new Signature(SIGNATURE_TYPE, this.signer.sign(metaHash.getValue()).getSignatureBytes());
            try {
                TimestampStreamFileWriter.writeSignatureFile(entireHash, entireSignature, metaHash, metaSignature, LinkedObjectStreamUtilities.generateSigFilePath(closedFile), this.streamType);
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "closeCurrentAndSign ::  :: Fail to generate signature file for {}", (Object)closedFile.getName(), (Object)e);
            }
        }
    }

    private void closeFile() {
        String fileName;
        String string = fileName = this.currentFile == null ? "null" : this.currentFile.getName();
        if (this.fileStream != null) {
            try {
                this.out.flush();
                this.fileStream.flush();
                this.fileStream.getChannel().force(true);
                this.fileStream.getFD().sync();
                this.out.close();
                this.fileStream.close();
                this.metadataOut.close();
                this.currentFile = null;
                this.fileStream = null;
                this.out = null;
                this.metadataOut = null;
            }
            catch (IOException e) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Exception in close file", (Throwable)e);
            }
            logger.info(LogMarker.OBJECT_STREAM_FILE.getMarker(), "File {} is closed at {}", new Supplier[]{() -> fileName, Instant::now});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldStartNewFile(T nextObject) {
        try {
            boolean timestampIsEligibleForNextFile;
            long currentPeriod;
            if (this.previousObject == null) {
                boolean bl = !this.startWriteAtCompleteWindow;
                return bl;
            }
            long previousPeriod = LinkedObjectStreamUtilities.getPeriod(((Timestamped)this.previousObject).getTimestamp(), this.windowSizeMs);
            boolean differentPeriod = previousPeriod != (currentPeriod = LinkedObjectStreamUtilities.getPeriod(((Timestamped)nextObject).getTimestamp(), this.windowSizeMs));
            boolean differentAlignment = this.previousObject.getStreamAlignment() != nextObject.getStreamAlignment() || nextObject.getStreamAlignment() == Long.MIN_VALUE;
            boolean bl = timestampIsEligibleForNextFile = this.previousHeldBackByAlignment || differentPeriod;
            if (timestampIsEligibleForNextFile && !differentAlignment) {
                this.previousHeldBackByAlignment = true;
                boolean bl2 = false;
                return bl2;
            }
            this.previousHeldBackByAlignment = false;
            boolean bl3 = timestampIsEligibleForNextFile;
            return bl3;
        }
        finally {
            this.previousObject = nextObject;
        }
    }

    private String generateStreamFilePath(T object) {
        return this.directory + File.separator + LinkedObjectStreamUtilities.generateStreamFileNameFromInstant(((Timestamped)object).getTimestamp(), this.streamType);
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.runningHash = new RunningHash(hash);
    }

    @Override
    public void addObject(T object) {
        if (this.shouldStartNewFile(object)) {
            this.closeCurrentAndSign();
            this.startNewFile(object);
            if (this.fileStream != null) {
                this.begin();
            }
        }
        if (this.fileStream != null) {
            this.serialize(object);
        }
        this.runningHash = ((RunningHashable)object).getRunningHash();
    }

    @Override
    public void clear() {
        if (this.fileStream != null) {
            File closedFile = this.currentFile;
            this.closeFile();
            try {
                Files.delete(closedFile.toPath());
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = closedFile::getName;
                logger.info(LogMarker.OBJECT_STREAM.getMarker(), "TimestampStreamFileWriter::clear deleted {}", supplierArray);
            }
            catch (IOException ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "TimestampStreamFileWriter::clear got IOException when deleting file {}", (Object)closedFile.getName(), (Object)ex);
            }
        }
    }

    @Override
    public void close() {
        this.closeCurrentAndSign();
        logger.info(LogMarker.FREEZE.getMarker(), "TimestampStreamFileWriter finished writing the last object, is stopped");
    }

    public boolean getStartWriteAtCompleteWindow() {
        return this.startWriteAtCompleteWindow;
    }

    public void setStartWriteAtCompleteWindow(boolean startWriteAtCompleteWindow) {
        this.startWriteAtCompleteWindow = startWriteAtCompleteWindow;
        logger.info(LogMarker.OBJECT_STREAM.getMarker(), "TimestampStreamFileWriter::setStartWriteAtCompleteWindow: {}", (Object)startWriteAtCompleteWindow);
    }
}

