/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system;

import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.SoftwareVersion;
import java.io.IOException;

public class BasicSoftwareVersion
implements SoftwareVersion {
    private static final long CLASS_ID = 8610499409588557872L;
    private long softwareVersion;

    public BasicSoftwareVersion() {
    }

    public BasicSoftwareVersion(long softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public long getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public long getClassId() {
        return 8610499409588557872L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.softwareVersion);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.softwareVersion = in.readLong();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int compareTo(SoftwareVersion that) {
        if (that == NO_VERSION) {
            return 1;
        }
        if (that instanceof BasicSoftwareVersion) {
            BasicSoftwareVersion thatVersion = (BasicSoftwareVersion)that;
            return Long.compare(this.softwareVersion, thatVersion.softwareVersion);
        }
        throw new IllegalArgumentException("Can not compare BasicSoftwareVersion to " + that.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicSoftwareVersion)) {
            return false;
        }
        BasicSoftwareVersion that = (BasicSoftwareVersion)o;
        return this.softwareVersion == that.softwareVersion;
    }

    public int hashCode() {
        return Long.hashCode(this.softwareVersion);
    }

    public String toString() {
        return Long.toString(this.softwareVersion);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

