/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBookUtils;
import com.swirlds.common.system.address.internal.AddressBookIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class AddressBook
extends PartialMerkleLeaf
implements Iterable<Address>,
MerkleLeaf {
    public static final long CLASS_ID = 5685030982988856288L;
    public static final int MAX_ADDRESSES = 1024;
    public static final long UNKNOWN_ROUND = Long.MIN_VALUE;
    private long round = Long.MIN_VALUE;
    private NodeId nextNodeId = NodeId.FIRST_NODE_ID;
    private final Map<NodeId, Address> addresses = new HashMap<NodeId, Address>();
    private final Map<String, NodeId> publicKeyToId = new HashMap<String, NodeId>();
    private final Map<NodeId, Integer> nodeIndices = new HashMap<NodeId, Integer>();
    private final List<NodeId> orderedNodeIds = new ArrayList<NodeId>();
    private long totalWeight;
    private int numberWithWeight;

    public AddressBook() {
        this(new ArrayList<Address>());
    }

    private AddressBook(@NonNull AddressBook that) {
        super(that);
        Objects.requireNonNull(that, "AddressBook must not be null");
        for (Address address : that) {
            this.addNewAddress(address);
        }
        this.round = that.round;
        this.nextNodeId = that.nextNodeId;
    }

    public AddressBook(@NonNull List<Address> addresses) {
        Objects.requireNonNull(addresses, "addresses must not be null");
        addresses.forEach(this::add);
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public long getClassId() {
        return 5685030982988856288L;
    }

    public long getRound() {
        return this.round;
    }

    public AddressBook setRound(long round) {
        this.throwIfImmutable();
        this.round = round;
        return this;
    }

    public int getSize() {
        return this.addresses.size();
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public int getNumberWithWeight() {
        return this.numberWithWeight;
    }

    public long getTotalWeight() {
        return this.totalWeight;
    }

    @Nullable
    public NodeId getNodeId(@NonNull String publicKey) {
        Objects.requireNonNull(publicKey, "publicKey must not be null");
        return this.publicKeyToId.get(publicKey);
    }

    @NonNull
    public NodeId getNodeId(int index) {
        if (index < 0 || index >= this.addresses.size()) {
            throw new NoSuchElementException("no address with index " + index + " exists");
        }
        return this.orderedNodeIds.get(index);
    }

    public int getIndexOfNodeId(@NonNull NodeId id) {
        Objects.requireNonNull(id, "nodeId is null");
        if (!this.addresses.containsKey(id)) {
            throw new NoSuchElementException("no address with id " + id + " exists");
        }
        return this.nodeIndices.getOrDefault(id, -1);
    }

    @NonNull
    public NodeId getNextNodeId() {
        return this.nextNodeId;
    }

    @NonNull
    public AddressBook setNextNodeId(@NonNull NodeId newNextNodeId) {
        this.throwIfImmutable();
        Objects.requireNonNull(newNextNodeId);
        if (newNextNodeId.compareTo(this.nextNodeId) < 0) {
            throw new IllegalArgumentException("The provided nextNodeId %s is less than the current nextNodeId %s".formatted(newNextNodeId, this.nextNodeId));
        }
        this.nextNodeId = newNextNodeId;
        return this;
    }

    @NonNull
    public Address getAddress(@NonNull NodeId id) {
        Objects.requireNonNull(id, "NodeId is null");
        Address address = this.addresses.get(id);
        if (address == null) {
            throw new NoSuchElementException("no address with id " + id + " exists");
        }
        return address;
    }

    public boolean contains(@Nullable NodeId id) {
        return id != null && this.addresses.containsKey(id);
    }

    private void addToOrderedList(@NonNull NodeId nodeId) {
        int index = this.orderedNodeIds.size();
        this.orderedNodeIds.add(nodeId);
        this.nodeIndices.put(nodeId, index);
    }

    private void removeNodeFromOrderedList(@NonNull NodeId nodeId) {
        int indexToRemove = this.nodeIndices.remove(nodeId);
        this.orderedNodeIds.remove(indexToRemove);
        for (int index = indexToRemove; index < this.orderedNodeIds.size(); ++index) {
            this.nodeIndices.put(this.orderedNodeIds.get(index), index);
        }
    }

    public void updateWeight(@NonNull NodeId id, long weight) {
        Objects.requireNonNull(id, "NodeId is null");
        this.throwIfImmutable();
        Address address = this.getAddress(id);
        if (weight < 0L) {
            throw new IllegalArgumentException("weight must be nonnegative");
        }
        this.updateAddress(address.copySetWeight(weight));
    }

    private void updateAddress(@NonNull Address address) {
        Address oldAddress = Objects.requireNonNull(this.addresses.put(address.getNodeId(), address));
        this.publicKeyToId.remove(oldAddress.getNickname());
        this.publicKeyToId.put(address.getNickname(), address.getNodeId());
        long oldWeight = oldAddress.getWeight();
        long newWeight = address.getWeight();
        this.totalWeight -= oldWeight;
        this.totalWeight += newWeight;
        if (oldWeight == 0L && newWeight != 0L) {
            ++this.numberWithWeight;
        } else if (oldWeight != 0L && newWeight == 0L) {
            --this.numberWithWeight;
        }
        this.addresses.put(address.getNodeId(), address);
    }

    private void addNewAddress(@NonNull Address address) {
        NodeId addressNodeId = address.getNodeId();
        int nodeIdComparison = addressNodeId.compareTo(this.nextNodeId);
        if (nodeIdComparison < 0) {
            throw new IllegalArgumentException("Can not add address with node ID " + address.getNodeId() + ", the next address to be added is required have a node ID greater or equal to " + this.nextNodeId);
        }
        if (this.addresses.size() >= 1024) {
            throw new IllegalStateException("Address book is only permitted to hold 1024 entries");
        }
        this.nextNodeId = addressNodeId.getOffset(1L);
        this.addresses.put(address.getNodeId(), address);
        this.publicKeyToId.put(address.getNickname(), address.getNodeId());
        this.addToOrderedList(address.getNodeId());
        this.totalWeight += address.getWeight();
        if (!address.isZeroWeight()) {
            ++this.numberWithWeight;
        }
    }

    @NonNull
    public AddressBook add(@NonNull Address address) {
        this.throwIfImmutable();
        Objects.requireNonNull(address, "address must not be null");
        if (this.addresses.containsKey(address.getNodeId())) {
            this.updateAddress(address);
        } else {
            this.addNewAddress(address);
        }
        return this;
    }

    @NonNull
    public AddressBook remove(@NonNull NodeId id) {
        Objects.requireNonNull(id, "NodeId is null");
        this.throwIfImmutable();
        Address address = this.addresses.remove(id);
        if (address == null) {
            return this;
        }
        this.publicKeyToId.remove(address.getNickname());
        this.removeNodeFromOrderedList(id);
        this.totalWeight -= address.getWeight();
        if (!address.isZeroWeight()) {
            --this.numberWithWeight;
        }
        this.orderedNodeIds.remove(id);
        return this;
    }

    public void clear() {
        this.throwIfImmutable();
        this.addresses.clear();
        this.publicKeyToId.clear();
        this.nodeIndices.clear();
        this.orderedNodeIds.clear();
        this.totalWeight = 0L;
        this.numberWithWeight = 0;
        this.nextNodeId = NodeId.FIRST_NODE_ID;
    }

    @Override
    @NonNull
    public AddressBook copy() {
        return new AddressBook(this);
    }

    @NonNull
    public AddressBook seal() {
        this.setImmutable(true);
        return this;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        Objects.requireNonNull(out, "out must not be null");
        out.writeSerializableIterableWithSize(this.iterator(), this.addresses.size(), false, true);
        out.writeLong(this.round);
        out.writeSerializable(this.nextNodeId, false);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        Objects.requireNonNull(in, "in must not be null");
        in.readSerializableIterableWithSize(1024, false, Address::new, this::addNewAddress);
        this.round = in.readLong();
        this.nextNodeId = version < 5 ? new NodeId(in.readLong()) : in.readSerializable(false, NodeId::new);
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 4;
    }

    @Override
    @NonNull
    public Iterator<Address> iterator() {
        return new AddressBookIterator(this.orderedNodeIds.iterator(), this.addresses);
    }

    @NonNull
    public Set<NodeId> getNodeIdSet() {
        return new HashSet<NodeId>(this.addresses.keySet());
    }

    @NonNull
    public String toConfigText() {
        return AddressBookUtils.addressBookConfigText(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressBook that = (AddressBook)o;
        return Objects.equals(this.addresses, that.addresses) && this.getRound() == that.getRound() && Objects.equals(this.getNextNodeId(), that.getNextNodeId());
    }

    public int hashCode() {
        return this.addresses.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressBook {\n");
        for (Address address : this) {
            sb.append("   ").append(address).append(",\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 0;
        public static final int UNDOCUMENTED = 1;
        public static final int AD_HOC_SERIALIZATION = 2;
        public static final int UTILITY_SERIALIZATION = 3;
        public static final int ADDRESS_BOOK_STORE_SUPPORT = 4;
        public static final int SELF_SERIALIZABLE_NODE_ID = 5;

        private ClassVersion() {
        }
    }
}

