/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBook;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Objects;

public class AddressBookUtils {
    public static final String ADDRESS_KEYWORD = "address";
    public static final String NEXT_NODE_ID_KEYWORD = "nextNodeId";

    private AddressBookUtils() {
    }

    @NonNull
    public static String addressBookConfigText(@NonNull AddressBook addressBook) {
        Objects.requireNonNull(addressBook, "The addressBook must not be null.");
        TextTable table = new TextTable().setBordersEnabled(false);
        for (Address address : addressBook) {
            String memo = address.getMemo();
            boolean hasMemo = !memo.trim().isEmpty();
            boolean hasInternalIpv4 = address.getHostnameInternal() != null;
            boolean hasExternalIpv4 = address.getHostnameExternal() != null;
            table.addRow("address,", address.getNodeId() + ",", address.getNickname() + ",", address.getSelfName() + ",", address.getWeight() + ",", (hasInternalIpv4 ? address.getHostnameInternal() : "") + ",", address.getPortInternal() + ",", (hasExternalIpv4 ? address.getHostnameExternal() : "") + ",", address.getPortExternal() + (hasMemo ? "," : ""), memo);
        }
        String addresses = table.render();
        return addresses + "\nnextNodeId, " + addressBook.getNextNodeId();
    }

    @NonNull
    public static AddressBook parseAddressBookText(@NonNull String addressBookText) throws ParseException {
        Objects.requireNonNull(addressBookText, "The addressBookText must not be null.");
        AddressBook addressBook = new AddressBook();
        boolean nextNodeIdParsed = false;
        for (String line : addressBookText.split("\\r?\\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            if (trimmedLine.startsWith(ADDRESS_KEYWORD)) {
                Address address = AddressBookUtils.parseAddressText(trimmedLine);
                if (address == null) continue;
                addressBook.add(address);
                continue;
            }
            if (trimmedLine.startsWith(NEXT_NODE_ID_KEYWORD)) {
                NodeId nodeId = AddressBookUtils.parseNextNodeId(trimmedLine);
                addressBook.setNextNodeId(nodeId);
                nextNodeIdParsed = true;
                continue;
            }
            throw new ParseException("The line [%s] does not start with `%s` or `%s`.".formatted(line.substring(0, 30), ADDRESS_KEYWORD, NEXT_NODE_ID_KEYWORD), 0);
        }
        if (!nextNodeIdParsed) {
            throw new ParseException("The address book text does not contain a `nextNodeId` line.", 0);
        }
        return addressBook;
    }

    @NonNull
    public static NodeId parseNextNodeId(@NonNull String nextNodeId) throws ParseException {
        Objects.requireNonNull(nextNodeId, "The nextNodeId must not be null.");
        String[] parts = nextNodeId.split(",");
        if (parts.length != 2) {
            throw new ParseException("The nextNodeId [%s] does not have exactly 2 comma separated parts.".formatted(nextNodeId), 0);
        }
        if (!parts[0].trim().equals(NEXT_NODE_ID_KEYWORD)) {
            throw new ParseException("The nextNodeId [%s] does not start with the keyword `nextNodeId`.".formatted(nextNodeId), 0);
        }
        String nodeIdText = parts[1].trim();
        try {
            long nodeId = Long.parseLong(nodeIdText);
            if (nodeId < 0L) {
                throw new ParseException("The nextNodeId [%s] does not have a positive integer node id.".formatted(nextNodeId), 1);
            }
            return new NodeId(nodeId);
        }
        catch (NumberFormatException e) {
            throw new ParseException("The nextNodeId [%s] does not have a positive integer node id.".formatted(nextNodeId), 1);
        }
    }

    @Nullable
    public static Address parseAddressText(@NonNull String addressText) throws ParseException {
        int externalPort;
        InetAddress externalIp;
        int internalPort;
        InetAddress internalIp;
        long weight;
        NodeId nodeId;
        Objects.requireNonNull(addressText, "The addressText must not be null.");
        String[] textAndComment = addressText.split("#");
        if (textAndComment.length == 0 || textAndComment[0] == null || textAndComment[0].trim().isEmpty()) {
            return null;
        }
        String[] parts = addressText.split(",");
        if (parts.length < 9 || parts.length > 10) {
            throw new ParseException("Incorrect number of parts in the address line to parse correctly.", parts.length);
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (!parts[0].equals(ADDRESS_KEYWORD)) {
            throw new ParseException("The address line must start with 'address' and not '" + parts[0] + "'", 0);
        }
        try {
            nodeId = new NodeId(Long.parseLong(parts[1]));
        }
        catch (Exception e) {
            throw new ParseException("Cannot parse node id from '" + parts[1] + "'", 1);
        }
        String nickname = parts[2];
        String selfname = parts[3];
        try {
            weight = Long.parseLong(parts[4]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse value of weight from '" + parts[4] + "'", 4);
        }
        try {
            internalIp = InetAddress.getByName(parts[5]);
        }
        catch (UnknownHostException e) {
            throw new ParseException("Cannot parse ip address from '" + parts[5] + ",", 5);
        }
        try {
            internalPort = Integer.parseInt(parts[6]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[6] + "'", 6);
        }
        try {
            externalIp = InetAddress.getByName(parts[7]);
        }
        catch (UnknownHostException e) {
            throw new ParseException("Cannot parse ip address from '" + parts[7] + ",", 7);
        }
        try {
            externalPort = Integer.parseInt(parts[8]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[8] + "'", 8);
        }
        String memoToUse = parts.length == 10 ? parts[9] : "";
        return new Address(nodeId, nickname, selfname, weight, internalIp.getHostAddress(), internalPort, externalIp.getHostAddress(), externalPort, memoToUse);
    }

    public static void verifyReconnectAddressBooks(@NonNull AddressBook addressBook1, @NonNull AddressBook addressBook2) throws IllegalStateException {
        if (!addressBook1.getNextNodeId().equals(addressBook2.getNextNodeId())) {
            throw new IllegalStateException("The next node ids are not the same.");
        }
        int addressCount = addressBook1.getSize();
        if (addressCount != addressBook2.getSize()) {
            throw new IllegalStateException("The address books do not have the same number of addresses.");
        }
        for (int i = 0; i < addressCount; ++i) {
            Address address2;
            NodeId nodeId2;
            NodeId nodeId1 = addressBook1.getNodeId(i);
            if (!nodeId1.equals(nodeId2 = addressBook2.getNodeId(i))) {
                throw new IllegalStateException("The address books do not have the same node ids.");
            }
            Address address1 = addressBook1.getAddress(nodeId1);
            if (address1.equals(address2 = addressBook2.getAddress(nodeId2))) continue;
            throw new IllegalStateException("The address books do not have the same addresses.");
        }
    }
}

