/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.CommonUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class BaseEventUnhashedData
implements SelfSerializable {
    private static final long CLASS_ID = 3732249661177372305L;
    private static final int CLASS_VERSION = 1;
    private static final int MAX_SIG_LENGTH = 384;
    private static final long SEQUENCE_UNUSED = -1L;
    private long creatorSeq;
    private NodeId otherId;
    private long otherSeq;
    private byte[] signature;

    public BaseEventUnhashedData() {
    }

    public BaseEventUnhashedData(@Nullable NodeId otherId, @NonNull byte[] signature) {
        this.creatorSeq = -1L;
        this.otherId = otherId;
        this.signature = Objects.requireNonNull(signature, "signature must not be null");
        this.otherSeq = -1L;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.creatorSeq);
        out.writeLong(this.otherId == null ? -1L : this.otherId.id());
        out.writeLong(this.otherSeq);
        out.writeByteArray(this.signature);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.creatorSeq = in.readLong();
        this.otherId = NodeId.deserializeLong(in, true);
        this.otherSeq = in.readLong();
        this.signature = in.readByteArray(384);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEventUnhashedData that = (BaseEventUnhashedData)o;
        return this.creatorSeq == that.creatorSeq && Objects.equals(this.otherId, that.otherId) && this.otherSeq == that.otherSeq && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.creatorSeq, this.otherId, this.otherSeq);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public String toString() {
        int signatureLength = this.signature == null ? 0 : this.signature.length;
        return "BaseEventUnhashedData{creatorSeq=" + this.creatorSeq + ", otherId=" + this.otherId + ", otherSeq=" + this.otherSeq + ", signature=" + CommonUtils.hex(this.signature, signatureLength) + "}";
    }

    @Override
    public long getClassId() {
        return 3732249661177372305L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Nullable
    public NodeId getOtherId() {
        return this.otherId;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

