/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.crypto.AbstractSerializableHashable;
import com.swirlds.common.crypto.RunningHash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.io.OptionalSelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.events.BaseEventHashedData;
import com.swirlds.common.system.events.BaseEventUnhashedData;
import com.swirlds.common.system.events.ConsensusData;
import com.swirlds.common.system.events.EventSerializationOptions;
import java.io.IOException;
import java.util.Objects;

public class DetailedConsensusEvent
extends AbstractSerializableHashable
implements OptionalSelfSerializable<EventSerializationOptions>,
RunningHashable {
    public static final long CLASS_ID = -2139022923795222086L;
    public static final int CLASS_VERSION = 1;
    private BaseEventHashedData baseEventHashedData;
    private BaseEventUnhashedData baseEventUnhashedData;
    private ConsensusData consensusData;
    private final RunningHash runningHash = new RunningHash();

    public DetailedConsensusEvent() {
    }

    public DetailedConsensusEvent(BaseEventHashedData baseEventHashedData, BaseEventUnhashedData baseEventUnhashedData, ConsensusData consensusData) {
        this.baseEventHashedData = baseEventHashedData;
        this.baseEventUnhashedData = baseEventUnhashedData;
        this.consensusData = consensusData;
    }

    @Override
    public void serialize(SerializableDataOutputStream out, EventSerializationOptions option) throws IOException {
        DetailedConsensusEvent.serialize(out, this.baseEventHashedData, this.baseEventUnhashedData, this.consensusData, option);
    }

    public static void serialize(SerializableDataOutputStream out, BaseEventHashedData baseEventHashedData, BaseEventUnhashedData baseEventUnhashedData, ConsensusData consensusData, EventSerializationOptions option) throws IOException {
        out.writeOptionalSerializable(baseEventHashedData, false, option);
        out.writeSerializable(baseEventUnhashedData, false);
        out.writeSerializable(consensusData, false);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        DetailedConsensusEvent.serialize(out, this.baseEventHashedData, this.baseEventUnhashedData, this.consensusData, EventSerializationOptions.FULL);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.baseEventHashedData = in.readSerializable(false, BaseEventHashedData::new);
        this.baseEventUnhashedData = in.readSerializable(false, BaseEventUnhashedData::new);
        this.consensusData = in.readSerializable(false, ConsensusData::new);
    }

    @Override
    public RunningHash getRunningHash() {
        return this.runningHash;
    }

    public BaseEventHashedData getBaseEventHashedData() {
        return this.baseEventHashedData;
    }

    public BaseEventUnhashedData getBaseEventUnhashedData() {
        return this.baseEventUnhashedData;
    }

    public ConsensusData getConsensusData() {
        return this.consensusData;
    }

    @Override
    public long getClassId() {
        return -2139022923795222086L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.baseEventHashedData, this.baseEventUnhashedData, this.consensusData);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DetailedConsensusEvent that = (DetailedConsensusEvent)other;
        return Objects.equals(this.baseEventHashedData, that.baseEventHashedData) && Objects.equals(this.baseEventUnhashedData, that.baseEventUnhashedData) && Objects.equals(this.consensusData, that.consensusData);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("baseEventHashedData", (Object)this.baseEventHashedData).append("baseEventUnhashedData", (Object)this.baseEventUnhashedData).append("consensusData", (Object)this.consensusData).toString();
    }
}

