/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.status;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.system.status.PlatformStatus;
import com.swirlds.common.system.status.PlatformStatusConfig;
import com.swirlds.common.system.status.PlatformStatusGetter;
import com.swirlds.common.system.status.PlatformStatusStateMachine;
import com.swirlds.common.system.status.StatusActionSubmitter;
import com.swirlds.common.system.status.actions.PlatformStatusAction;
import com.swirlds.common.system.status.actions.TimeElapsedAction;
import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.config.QueueThreadConfiguration;
import com.swirlds.common.threading.framework.config.QueueThreadMetricsConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class PlatformStatusManager
implements PlatformStatusGetter,
StatusActionSubmitter,
Startable,
Stoppable {
    private final Time time;
    private final QueueThread<PlatformStatusAction> queue;
    private final PlatformStatusStateMachine stateMachine;

    public PlatformStatusManager(@NonNull PlatformContext platformContext, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull NotificationEngine notificationEngine) {
        this.time = Objects.requireNonNull(time);
        Objects.requireNonNull(threadManager);
        Objects.requireNonNull(notificationEngine);
        PlatformStatusConfig config = (PlatformStatusConfig)platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class);
        this.stateMachine = new PlatformStatusStateMachine(time, config, notificationEngine);
        this.queue = ((QueueThreadConfiguration)((QueueThreadConfiguration)((QueueThreadConfiguration)((QueueThreadConfiguration)((QueueThreadConfiguration)((QueueThreadConfiguration)((QueueThreadConfiguration)new QueueThreadConfiguration(threadManager).setComponent("platform")).setThreadName("status-state-machine")).setHandler(this::processStatusAction).setIdleCallback(this::triggerTimeElapsed)).setBatchHandledCallback(this::triggerTimeElapsed)).setWaitForWorkDuration(config.waitForWorkDuration())).setCapacity(config.statusActionQueueCapacity())).setMetricsConfiguration(new QueueThreadMetricsConfiguration(platformContext.getMetrics()).enableMaxSizeMetric().enableBusyTimeMetric())).build();
    }

    public void start() {
        this.queue.start();
    }

    public void stop() {
        this.queue.stop();
    }

    @Override
    public void submitStatusAction(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        this.queue.add(action);
    }

    private void processStatusAction(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        this.stateMachine.processStatusAction(action);
    }

    @Override
    @NonNull
    public PlatformStatus getCurrentStatus() {
        return this.stateMachine.getCurrentStatus();
    }

    private void triggerTimeElapsed() {
        this.stateMachine.processStatusAction(new TimeElapsedAction(this.time.now()));
    }
}

