/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.status;

import com.swirlds.base.time.Time;
import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.notification.listeners.PlatformStatusChangeListener;
import com.swirlds.common.notification.listeners.PlatformStatusChangeNotification;
import com.swirlds.common.system.status.IllegalPlatformStatusException;
import com.swirlds.common.system.status.PlatformStatus;
import com.swirlds.common.system.status.PlatformStatusConfig;
import com.swirlds.common.system.status.PlatformStatusGetter;
import com.swirlds.common.system.status.actions.CatastrophicFailureAction;
import com.swirlds.common.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.common.system.status.actions.EmergencyReconnectStartedAction;
import com.swirlds.common.system.status.actions.FallenBehindAction;
import com.swirlds.common.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.common.system.status.actions.PlatformStatusAction;
import com.swirlds.common.system.status.actions.ReconnectCompleteAction;
import com.swirlds.common.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.common.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.common.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.common.system.status.actions.TimeElapsedAction;
import com.swirlds.common.system.status.logic.PlatformStatusLogic;
import com.swirlds.common.system.status.logic.StartingUpStatusLogic;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.common.units.Unit;
import com.swirlds.logging.LogMarker;
import com.swirlds.logging.payloads.PlatformStatusPayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlatformStatusStateMachine
implements PlatformStatusGetter {
    private static final Logger logger = LogManager.getLogger(PlatformStatusStateMachine.class);
    private final Time time;
    private final NotificationEngine notificationEngine;
    private PlatformStatusLogic currentStatusLogic;
    private final AtomicReference<PlatformStatus> currentStatus;
    private Instant currentStatusStartTime;

    public PlatformStatusStateMachine(@NonNull Time time, @NonNull PlatformStatusConfig config, @NonNull NotificationEngine notificationEngine) {
        this.time = Objects.requireNonNull(time);
        this.notificationEngine = Objects.requireNonNull(notificationEngine);
        this.currentStatusLogic = new StartingUpStatusLogic(config);
        this.currentStatus = new AtomicReference<PlatformStatus>(this.currentStatusLogic.getStatus());
        this.currentStatusStartTime = time.now();
    }

    @Nullable
    private PlatformStatusLogic getNewLogic(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        Class<?> actionClass = action.getClass();
        try {
            if (actionClass == CatastrophicFailureAction.class) {
                return this.currentStatusLogic.processCatastrophicFailureAction((CatastrophicFailureAction)action);
            }
            if (actionClass == DoneReplayingEventsAction.class) {
                return this.currentStatusLogic.processDoneReplayingEventsAction((DoneReplayingEventsAction)action);
            }
            if (actionClass == EmergencyReconnectStartedAction.class) {
                return this.currentStatusLogic.processEmergencyReconnectStartedAction((EmergencyReconnectStartedAction)action);
            }
            if (actionClass == FallenBehindAction.class) {
                return this.currentStatusLogic.processFallenBehindAction((FallenBehindAction)action);
            }
            if (actionClass == FreezePeriodEnteredAction.class) {
                return this.currentStatusLogic.processFreezePeriodEnteredAction((FreezePeriodEnteredAction)action);
            }
            if (actionClass == ReconnectCompleteAction.class) {
                return this.currentStatusLogic.processReconnectCompleteAction((ReconnectCompleteAction)action);
            }
            if (actionClass == SelfEventReachedConsensusAction.class) {
                return this.currentStatusLogic.processSelfEventReachedConsensusAction((SelfEventReachedConsensusAction)action);
            }
            if (actionClass == StartedReplayingEventsAction.class) {
                return this.currentStatusLogic.processStartedReplayingEventsAction((StartedReplayingEventsAction)action);
            }
            if (actionClass == StateWrittenToDiskAction.class) {
                return this.currentStatusLogic.processStateWrittenToDiskAction((StateWrittenToDiskAction)action);
            }
            if (actionClass == TimeElapsedAction.class) {
                return this.currentStatusLogic.processTimeElapsedAction((TimeElapsedAction)action);
            }
            throw new IllegalArgumentException("Unknown action type: " + action.getClass().getName());
        }
        catch (IllegalPlatformStatusException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void processStatusAction(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        PlatformStatusLogic newLogic = this.getNewLogic(action);
        if (newLogic == null || newLogic == this.currentStatusLogic) {
            return;
        }
        String previousStatusName = this.currentStatusLogic.getStatus().name();
        String newStatusName = newLogic.getStatus().name();
        Duration statusDuration = Duration.between(this.currentStatusStartTime, this.time.now());
        UnitFormatter unitFormatter = new UnitFormatter(statusDuration.toMillis(), (Unit<?>)TimeUnit.UNIT_MILLISECONDS);
        String statusChangeMessage = "Platform spent %s in %s. Now in %s".formatted(unitFormatter.render(), previousStatusName, newStatusName);
        logger.info(LogMarker.PLATFORM_STATUS.getMarker(), () -> new PlatformStatusPayload(statusChangeMessage, previousStatusName, newStatusName).toString());
        this.currentStatusLogic = newLogic;
        this.currentStatus.set(this.currentStatusLogic.getStatus());
        this.currentStatusStartTime = this.time.now();
        this.notificationEngine.dispatch(PlatformStatusChangeListener.class, new PlatformStatusChangeNotification(newLogic.getStatus()));
    }

    @Override
    @NonNull
    public PlatformStatus getCurrentStatus() {
        return this.currentStatus.get();
    }
}

