/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.status.logic;

import com.swirlds.common.system.status.IllegalPlatformStatusException;
import com.swirlds.common.system.status.PlatformStatus;
import com.swirlds.common.system.status.PlatformStatusConfig;
import com.swirlds.common.system.status.actions.CatastrophicFailureAction;
import com.swirlds.common.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.common.system.status.actions.EmergencyReconnectStartedAction;
import com.swirlds.common.system.status.actions.FallenBehindAction;
import com.swirlds.common.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.common.system.status.actions.ReconnectCompleteAction;
import com.swirlds.common.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.common.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.common.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.common.system.status.actions.TimeElapsedAction;
import com.swirlds.common.system.status.logic.CatastrophicFailureStatusLogic;
import com.swirlds.common.system.status.logic.PlatformStatusLogic;
import com.swirlds.common.system.status.logic.ReconnectCompleteStatusLogic;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class BehindStatusLogic
implements PlatformStatusLogic {
    private final PlatformStatusConfig config;
    private Long freezeRound = null;

    public BehindStatusLogic(@NonNull PlatformStatusConfig config) {
        this.config = config;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processCatastrophicFailureAction(@NonNull CatastrophicFailureAction action) {
        return new CatastrophicFailureStatusLogic();
    }

    @Override
    @NonNull
    public PlatformStatusLogic processDoneReplayingEventsAction(@NonNull DoneReplayingEventsAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processEmergencyReconnectStartedAction(@NonNull EmergencyReconnectStartedAction action) {
        return this;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFallenBehindAction(@NonNull FallenBehindAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFreezePeriodEnteredAction(@NonNull FreezePeriodEnteredAction action) {
        if (this.freezeRound != null) {
            throw new IllegalPlatformStatusException("Received duplicate freeze period notification in BEHIND status. Previous notification was for round " + this.freezeRound + ", new notification is for round " + action.freezeRound());
        }
        this.freezeRound = action.freezeRound();
        return this;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processReconnectCompleteAction(@NonNull ReconnectCompleteAction action) {
        return new ReconnectCompleteStatusLogic(action.reconnectStateRound(), this.freezeRound, this.config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processSelfEventReachedConsensusAction(@NonNull SelfEventReachedConsensusAction action) {
        return this;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStartedReplayingEventsAction(@NonNull StartedReplayingEventsAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStateWrittenToDiskAction(@NonNull StateWrittenToDiskAction action) {
        return this;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processTimeElapsedAction(@NonNull TimeElapsedAction action) {
        return this;
    }

    @Override
    @NonNull
    public PlatformStatus getStatus() {
        return PlatformStatus.BEHIND;
    }
}

