/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.transaction.internal;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.transaction.SystemTransactionType;
import com.swirlds.common.system.transaction.internal.SystemTransaction;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Objects;

public final class StateSignatureTransaction
extends SystemTransaction {
    private static final long CLASS_ID = -5805099485452653580L;
    private Signature stateSignature;
    private Hash stateHash;
    private Hash epochHash;
    private long round = 0L;

    public StateSignatureTransaction() {
    }

    public StateSignatureTransaction(long round, @NonNull Signature stateSignature, @NonNull Hash stateHash, @Nullable Hash epochHash) {
        this.round = round;
        this.stateSignature = Objects.requireNonNull(stateSignature, "stateSignature must not be null");
        this.stateHash = Objects.requireNonNull(stateHash, "stateHash must not be null");
        this.epochHash = epochHash;
    }

    public StateSignatureTransaction(long round, @NonNull Signature stateSignature, @NonNull Hash stateHash) {
        this(round, stateSignature, stateHash, null);
    }

    public long getRound() {
        return this.round;
    }

    public Signature getStateSignature() {
        return this.stateSignature;
    }

    public Hash getStateHash() {
        return this.stateHash;
    }

    @Nullable
    public Hash getEpochHash() {
        return this.epochHash;
    }

    @Override
    public int getSize() {
        return this.getSerializedLength();
    }

    @Override
    public SystemTransactionType getType() {
        return SystemTransactionType.SYS_TRANS_STATE_SIG;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.stateSignature.getSignatureBytes());
        if (this.stateHash == null) {
            out.writeByteArray(new byte[0]);
        } else {
            out.writeByteArray(this.stateHash.getValue());
        }
        out.writeLong(this.round);
        out.writeSerializable(this.epochHash, false);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        byte[] hashBytes;
        if (version == 1) {
            in.readBoolean();
        }
        this.stateSignature = new Signature(SignatureType.RSA, in.readByteArray(SignatureType.RSA.signatureLength()));
        if (version >= 2 && (hashBytes = in.readByteArray(DigestType.SHA_384.digestLength())).length != 0) {
            this.stateHash = new Hash(hashBytes, DigestType.SHA_384);
        }
        this.round = in.readLong();
        if (version >= 3) {
            this.epochHash = in.readSerializable(false, Hash::new);
        }
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 1;
    }

    @Override
    public long getClassId() {
        return -5805099485452653580L;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public int getSerializedLength() {
        return AugmentedDataOutputStream.getArraySerializedLength(this.stateSignature.getSignatureBytes()) + AugmentedDataOutputStream.getArraySerializedLength(this.stateHash == null ? new byte[]{} : this.stateHash.getValue()) + SerializableDataOutputStream.getInstanceSerializedLength(this.epochHash, true, false) + 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateSignatureTransaction that = (StateSignatureTransaction)o;
        return this.round == that.round && Objects.equals(this.stateSignature, that.stateSignature) && Objects.equals(this.stateHash, that.stateHash) && Objects.equals(this.epochHash, that.epochHash);
    }

    public int hashCode() {
        return Objects.hash(this.stateSignature, this.stateHash, this.round, this.epochHash);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int ADDED_SELF_HASH = 2;
        public static final int ADDED_EPOCH_HASH = 3;

        private ClassVersion() {
        }
    }
}

