/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.transaction.internal;

import com.swirlds.common.config.TransactionConfig;
import com.swirlds.common.config.singleton.ConfigurationHolder;
import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.transaction.SystemTransactionType;
import com.swirlds.common.system.transaction.internal.SystemTransaction;
import java.io.IOException;
import java.util.Arrays;

public final class SystemTransactionBitsPerSecond
extends SystemTransaction {
    private static final long BPS_CLASS_ID = 7575656545372712089L;
    private static final int BPS_CLASS_VERSION = 1;
    private long[] avgBitsPerSecSent;

    public SystemTransactionBitsPerSecond() {
    }

    public SystemTransactionBitsPerSecond(long[] avgBitsPerSecSent) {
        this.avgBitsPerSecSent = avgBitsPerSecSent;
    }

    public long[] getAvgBitsPerSecSent() {
        return this.avgBitsPerSecSent;
    }

    @Override
    public int getSize() {
        return this.getSerializedLength();
    }

    @Override
    public SystemTransactionType getType() {
        return SystemTransactionType.SYS_TRANS_BITS_PER_SECOND;
    }

    @Override
    public void serialize(SerializableDataOutputStream dos) throws IOException {
        dos.writeLongArray(this.avgBitsPerSecSent);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        TransactionConfig transactionConfig = ConfigurationHolder.getConfigData(TransactionConfig.class);
        this.avgBitsPerSecSent = in.readLongArray(transactionConfig.maxAddressSizeAllowed());
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 1;
    }

    @Override
    public long getClassId() {
        return 7575656545372712089L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getSerializedLength() {
        return AugmentedDataOutputStream.getArraySerializedLength(this.avgBitsPerSecSent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemTransactionBitsPerSecond that = (SystemTransactionBitsPerSecond)o;
        return Arrays.equals(this.avgBitsPerSecSent, that.avgBitsPerSecSent);
    }

    public int hashCode() {
        return Arrays.hashCode(this.avgBitsPerSecSent);
    }
}

