/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.futures;

import com.swirlds.common.utility.StackTrace;
import com.swirlds.logging.LogMarker;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardFuture<T>
implements Future<T> {
    private static final Logger logger = LogManager.getLogger(StandardFuture.class);
    private final CountDownLatch latch;
    private final CompletionCallback<T> completionCallback;
    private final CancellationCallback cancellationCallback;
    private T value;
    private boolean cancelled;
    private Throwable exception;

    public StandardFuture() {
        this.latch = new CountDownLatch(1);
        this.cancellationCallback = null;
        this.completionCallback = null;
    }

    public StandardFuture(T value) {
        this.latch = null;
        this.cancellationCallback = null;
        this.completionCallback = null;
        this.value = value;
    }

    public StandardFuture(CancellationCallback cancellationCallback) {
        this(null, cancellationCallback);
    }

    public StandardFuture(CompletionCallback<T> completionCallback) {
        this(completionCallback, null);
    }

    public StandardFuture(CompletionCallback<T> completionCallback, CancellationCallback cancellationCallback) {
        this.latch = new CountDownLatch(1);
        this.cancellationCallback = cancellationCallback;
        this.completionCallback = completionCallback;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.latch == null || this.latch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.latch != null) {
            this.latch.await();
        }
        if (this.cancelled) {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            throw new CancellationException();
        }
        return this.value;
    }

    public T getAndRethrow() throws InterruptedException {
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.latch != null && !this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.cancelled) {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            throw new CancellationException();
        }
        return this.value;
    }

    public T getAndRethrow(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            return this.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected T getRawValue() {
        return this.value;
    }

    public synchronized void complete(T value) {
        if (this.isDone()) {
            if (this.cancelled) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been cancelled, can't complete (provided value = {})\n{}", value, (Object)StackTrace.getStackTrace());
            } else {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been completed can not complete again (current value = {}, provided value = {})\n{}", this.value, value, (Object)StackTrace.getStackTrace());
            }
            return;
        }
        this.value = value;
        assert (this.latch != null);
        this.latch.countDown();
        if (this.completionCallback != null) {
            this.completionCallback.futureIsComplete(value);
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            if (this.cancelled) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been cancelled\n{}", (Object)StackTrace.getStackTrace());
            } else {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been completed, can not cancel (current value = {})\n{}", this.value, (Object)StackTrace.getStackTrace());
            }
            return false;
        }
        this.cancelled = true;
        if (this.latch != null) {
            this.latch.countDown();
        }
        if (this.cancellationCallback != null) {
            this.cancellationCallback.futureIsCancelled(mayInterruptIfRunning, null);
        }
        return true;
    }

    public void cancel() {
        this.cancel(false);
    }

    public void cancelWithError(Throwable error) {
        this.cancelWithError(false, error);
    }

    public synchronized void cancelWithError(boolean mayInterruptIfRunning, Throwable error) {
        if (this.isDone()) {
            if (this.cancelled) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been cancelled\n{}", (Object)StackTrace.getStackTrace());
            } else {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Future has already been completed, can not cancel (current value = {})\n{}", this.value, (Object)StackTrace.getStackTrace());
            }
            return;
        }
        if (this.cancellationCallback != null) {
            this.cancellationCallback.futureIsCancelled(mayInterruptIfRunning, error);
        }
        this.cancelled = true;
        this.exception = error;
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    @FunctionalInterface
    public static interface CancellationCallback {
        public void futureIsCancelled(boolean var1, Throwable var2);
    }

    @FunctionalInterface
    public static interface CompletionCallback<T> {
        public void futureIsComplete(T var1);
    }
}

