/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.pool;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.futures.ConcurrentFuturePool;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.LogMarker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardWorkGroup {
    private static final Logger logger = LogManager.getLogger(StandardWorkGroup.class);
    private static final String DEFAULT_TASK_NAME = "IDLE";
    private final String groupName;
    private final ExecutorService executorService;
    private final ConcurrentFuturePool<Void> futures;
    private volatile boolean hasExceptions;
    private final AtomicBoolean firstException = new AtomicBoolean(true);
    private final Runnable abortAction;
    private final Function<Throwable, Boolean> exceptionListener;

    public StandardWorkGroup(ThreadManager threadManager, String groupName, Runnable abortAction) {
        this(threadManager, groupName, abortAction, null);
    }

    public StandardWorkGroup(ThreadManager threadManager, String groupName, Runnable abortAction, Function<Throwable, Boolean> exceptionListener) {
        this.groupName = groupName;
        this.futures = new ConcurrentFuturePool(this::handleError);
        this.abortAction = abortAction;
        this.exceptionListener = exceptionListener;
        ThreadConfiguration configuration = (ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setComponent("work group " + groupName)).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception ", ex))).setThreadName(DEFAULT_TASK_NAME);
        this.executorService = Executors.newCachedThreadPool(configuration.buildFactory());
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public void execute(Runnable operation) {
        this.futures.add(this.executorService.submit(operation));
    }

    public void execute(String taskName, Runnable operation) {
        Runnable wrapper = () -> {
            String originalThreadName = Thread.currentThread().getName();
            String newThreadName = originalThreadName.replaceFirst(DEFAULT_TASK_NAME, taskName);
            try {
                Thread.currentThread().setName(newThreadName);
                operation.run();
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
            }
        };
        this.execute(wrapper);
    }

    public boolean hasExceptions() {
        return this.hasExceptions;
    }

    public void waitForTermination() throws InterruptedException {
        this.futures.waitForCompletion();
        this.executorService.shutdown();
        while (!this.executorService.isTerminated() && !this.executorService.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
        }
    }

    public void handleError(Throwable ex) {
        if (!(ex instanceof InterruptedException)) {
            boolean exceptionHandled = false;
            if (this.exceptionListener != null) {
                exceptionHandled = this.exceptionListener.apply(ex);
            }
            if (!exceptionHandled) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Work Group Exception [ groupName = {} ]", (Object)this.groupName, (Object)ex);
            }
            this.hasExceptions = true;
            if (this.abortAction != null && this.firstException.getAndSet(false)) {
                this.abortAction.run();
            }
            this.executorService.shutdownNow();
        }
    }
}

