/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.utility.ByteUtils;
import com.swirlds.common.utility.CommonUtils;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class NonCryptographicHashing {
    private NonCryptographicHashing() {
    }

    private static long computeMixin(@NonNull DataType type, long length) {
        return (long)type.ordinal() | length << 32;
    }

    public static long hash64(long x0) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 1L)) ^ x0);
    }

    public static long hash64(long x0, long x1) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 2L)) ^ x0) ^ x1);
    }

    public static long hash64(long x0, long x1, long x2) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 3L)) ^ x0) ^ x1) ^ x2);
    }

    public static long hash64(long x0, long x1, long x2, long x3) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 4L)) ^ x0) ^ x1) ^ x2) ^ x3);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 5L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4, long x5) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 6L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4) ^ x5);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4, long x5, long x6) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 7L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4) ^ x5) ^ x6);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 8L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4) ^ x5) ^ x6) ^ x7);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7, long x8) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 9L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4) ^ x5) ^ x6) ^ x7) ^ x8);
    }

    public static long hash64(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7, long x8, long x9) {
        return NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG, 10L)) ^ x0) ^ x1) ^ x2) ^ x3) ^ x4) ^ x5) ^ x6) ^ x7) ^ x8) ^ x9);
    }

    public static long hash64(long ... x) {
        long t = NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.LONG_ARRAY, x.length));
        for (long l : x) {
            t = NonCryptographicHashing.perm64(t ^ l);
        }
        return t;
    }

    public static int hash32(long x0) {
        return (int)NonCryptographicHashing.hash64(x0);
    }

    public static int hash32(long x0, long x1) {
        return (int)NonCryptographicHashing.hash64(x0, x1);
    }

    public static int hash32(long x0, long x1, long x2) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2);
    }

    public static int hash32(long x0, long x1, long x2, long x3) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4, long x5) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4, x5);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4, long x5, long x6) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4, x5, x6);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4, x5, x6, x7);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7, long x8) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4, x5, x6, x7, x8);
    }

    public static int hash32(long x0, long x1, long x2, long x3, long x4, long x5, long x6, long x7, long x8, long x9) {
        return (int)NonCryptographicHashing.hash64(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
    }

    public static int hash32(long ... x) {
        return (int)NonCryptographicHashing.hash64(x);
    }

    public static long hash64(@NonNull byte[] bytes) {
        long hash = NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.BYTE_ARRAY, bytes.length));
        for (int i = 0; i < bytes.length; i += 8) {
            hash = NonCryptographicHashing.perm64(hash ^ ByteUtils.byteArrayToLong(bytes, i));
        }
        return hash;
    }

    public static long hash32(@NonNull byte[] bytes) {
        return (int)NonCryptographicHashing.hash64(bytes);
    }

    public static long hash64(@NonNull String string) {
        byte[] bytes = CommonUtils.getNormalisedStringBytes(string);
        long hash = NonCryptographicHashing.perm64(NonCryptographicHashing.computeMixin(DataType.STRING, bytes.length));
        for (int i = 0; i < bytes.length; i += 8) {
            hash = NonCryptographicHashing.perm64(hash ^ ByteUtils.byteArrayToLong(bytes, i));
        }
        return hash;
    }

    public static int hash32(@NonNull String string) {
        return (int)NonCryptographicHashing.hash64(string);
    }

    private static long perm64(long x) {
        x ^= 0x5E8A016A5EB99C18L;
        x += x << 30;
        x ^= x >>> 27;
        x += x << 16;
        x ^= x >>> 20;
        x += x << 5;
        x ^= x >>> 18;
        x += x << 10;
        x ^= x >>> 24;
        x += x << 30;
        return x;
    }

    private static enum DataType {
        LONG,
        LONG_ARRAY,
        BYTE_ARRAY,
        STRING;

    }
}

