/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.utility.AbstractReservable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReferenceCounter
extends AbstractReservable {
    private final Runnable onDestroy;
    private final Runnable onReferenceCountException;

    public ReferenceCounter(Runnable onDestroy) {
        this(onDestroy, null);
    }

    public ReferenceCounter(@NonNull Runnable onDestroy, @Nullable Runnable onReferenceCountException) {
        this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy");
        this.onReferenceCountException = onReferenceCountException;
    }

    @Override
    protected void onDestroy() {
        this.onDestroy.run();
    }

    @Override
    protected void onReferenceCountException() {
        if (this.onReferenceCountException != null) {
            this.onReferenceCountException.run();
        }
    }

    public String toString() {
        int reservationCount = this.getReservationCount();
        if (reservationCount == -1) {
            return "destroyed(-1)";
        }
        if (reservationCount == 0) {
            return "implicit(0)";
        }
        return "explicit(" + reservationCount + ")";
    }
}

