/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.base.time.Time;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final Time time;
    private long startTime;
    private long endTime;
    private boolean running;
    private boolean suspended;

    public StopWatch() {
        this(Time.getCurrent());
    }

    public StopWatch(@NonNull Time time) {
        this.time = Objects.requireNonNull(time);
        this.running = false;
        this.suspended = false;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("StopWatch is already running.");
        }
        this.running = true;
        this.startTime = this.time.nanoTime();
    }

    public void stop() {
        long nanoTime = this.time.nanoTime();
        if (!this.running || this.suspended) {
            throw new IllegalStateException("StopWatch is not running.");
        }
        this.endTime = nanoTime;
        this.running = false;
    }

    public void suspend() {
        long nanoTime = this.time.nanoTime();
        if (!this.running || this.suspended) {
            throw new IllegalStateException("StopWatch is not running or is already suspended.");
        }
        this.endTime = nanoTime;
        this.suspended = true;
    }

    public void resume() {
        long nanoTime = this.time.nanoTime();
        if (!this.suspended) {
            throw new IllegalStateException("StopWatch is not suspended.");
        }
        this.startTime += nanoTime - this.endTime;
        this.suspended = false;
    }

    public long getElapsedTimeNano() {
        long nanoTime = this.time.nanoTime();
        if (this.startTime == 0L && this.endTime == 0L) {
            throw new IllegalStateException("StopWatch has not started yet.");
        }
        if (this.running) {
            return nanoTime - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isStopped() {
        return !this.running && !this.suspended;
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.running = false;
    }

    public long getTime(@NonNull TimeUnit unit) {
        Objects.requireNonNull(unit, "unit is null");
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.NANOSECONDS -> this.getElapsedTimeNano();
            case TimeUnit.MICROSECONDS -> TimeUnit.NANOSECONDS.toMicros(this.getElapsedTimeNano());
            case TimeUnit.MILLISECONDS -> TimeUnit.NANOSECONDS.toMillis(this.getElapsedTimeNano());
            case TimeUnit.SECONDS -> TimeUnit.NANOSECONDS.toSeconds(this.getElapsedTimeNano());
            case TimeUnit.MINUTES -> TimeUnit.NANOSECONDS.toMinutes(this.getElapsedTimeNano());
            case TimeUnit.HOURS -> TimeUnit.NANOSECONDS.toHours(this.getElapsedTimeNano());
            case TimeUnit.DAYS -> TimeUnit.NANOSECONDS.toDays(this.getElapsedTimeNano());
        };
    }
}

