/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.context;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.CryptographyHolder;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.PlatformMetricsProvider;
import com.swirlds.common.system.NodeId;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public final class DefaultPlatformContext
implements PlatformContext {
    private final Configuration configuration;
    private final Metrics metrics;
    private final Cryptography cryptography;

    public DefaultPlatformContext(NodeId nodeId, @NonNull PlatformMetricsProvider metricsProvider, @NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.metrics = Objects.requireNonNull(metricsProvider, "metricsProvider must not be null").createPlatformMetrics(nodeId);
        this.cryptography = CryptographyHolder.get();
    }

    public DefaultPlatformContext(Configuration configuration, Metrics metrics, Cryptography cryptography) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.cryptography = Objects.requireNonNull(cryptography, "cryptography");
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Cryptography getCryptography() {
        return this.cryptography;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }
}

