/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.config;

import com.swirlds.config.api.ConfigData;

@ConfigData(value="crypto")
public record CryptoConfig(double cpuVerifierThreadRatio, double cpuDigestThreadRatio, int cpuVerifierQueueSize, int cpuDigestQueueSize, String keystorePassword) {
    public int computeCpuVerifierThreadCount() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        double interimThreadCount = Math.ceil((double)numberOfCores * this.cpuVerifierThreadRatio());
        return interimThreadCount >= 1.0 ? (int)interimThreadCount : 1;
    }

    public int computeCpuDigestThreadCount() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        double interimThreadCount = Math.ceil((double)numberOfCores * this.cpuDigestThreadRatio());
        return interimThreadCount >= 1.0 ? (int)interimThreadCount : 1;
    }
}

