/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.engine.OperationProvider;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public abstract class CachingOperationProvider<Element, OptionalData, Result, Alg, AlgType extends Enum<AlgType>>
extends OperationProvider<Element, OptionalData, Result, Alg, AlgType> {
    private final ThreadLocal<HashMap<AlgType, Alg>> context = ThreadLocal.withInitial(HashMap::new);

    @Override
    protected Alg loadAlgorithm(AlgType algorithmType) throws NoSuchAlgorithmException {
        HashMap<AlgType, Alg> algorithmCache = this.context.get();
        if (algorithmCache.containsKey(algorithmType)) {
            return algorithmCache.get(algorithmType);
        }
        Alg algorithm = this.handleAlgorithmRequired(algorithmType);
        algorithmCache.putIfAbsent(algorithmType, algorithm);
        return algorithm;
    }

    protected abstract Alg handleAlgorithmRequired(AlgType var1) throws NoSuchAlgorithmException;
}

