/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.constructable.ClassIdFormatter;
import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.exceptions.ClassNotFoundException;
import com.swirlds.common.io.exceptions.MerkleSerializationException;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.internal.MerkleTreeSerializationOptions;
import com.swirlds.common.io.streams.internal.PartiallyConstructedMerkleInternal;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleInitialize;
import com.swirlds.common.merkle.exceptions.IllegalChildCountException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;

public class MerkleDataInputStream
extends SerializableDataInputStream {
    private final Queue<PartiallyConstructedMerkleInternal> internalNodes = new LinkedList<PartiallyConstructedMerkleInternal>();
    private MerkleNode root;

    public MerkleDataInputStream(InputStream in) {
        super(in);
    }

    private void addToParent(MerkleNode child) {
        if (this.internalNodes.isEmpty()) {
            this.root = child;
        } else {
            PartiallyConstructedMerkleInternal nextParent = this.internalNodes.peek();
            nextParent.addChild(child);
            if (nextParent.hasAllChildren()) {
                nextParent.finishConstruction();
                this.internalNodes.remove();
            }
        }
    }

    private void finishReadingLeaf(Path directory, MerkleLeaf node, int version) throws IOException {
        node.deserialize(this, directory, version);
        this.addToParent(node);
    }

    private void finishReadingInternal(Path directory, MerkleInternal node, int version) throws IOException {
        if (node instanceof ExternalSelfSerializable) {
            ((ExternalSelfSerializable)((Object)node)).deserialize(this, directory, version);
            this.addToParent(node);
        } else {
            int childCount = this.readInt();
            if (childCount < node.getMinimumChildCount() || childCount > node.getMaximumChildCount()) {
                throw new IllegalChildCountException(node.getClassId(), version, node.getMinimumChildCount(), node.getMaximumChildCount(), childCount);
            }
            this.addToParent(node);
            if (childCount > 0) {
                this.internalNodes.add(new PartiallyConstructedMerkleInternal(node, version, childCount));
            }
        }
    }

    protected void readNextNode(Path directory, Map<Long, Integer> deserializedVersions) throws IOException {
        long classId = this.readLong();
        this.recordClassId(classId);
        if (classId == Long.MIN_VALUE) {
            this.addToParent(null);
            return;
        }
        MerkleNode node = (MerkleNode)ConstructableRegistry.getInstance().createObject(classId);
        if (node == null) {
            throw new ClassNotFoundException(classId);
        }
        this.recordClass(node);
        int classVersion = this.readInt();
        this.validateVersion(node, classVersion);
        Integer previous = deserializedVersions.put(classId, classVersion);
        if (previous != null && previous != classVersion) {
            throw new IllegalStateException("Class with class ID " + ClassIdFormatter.classIdString(classId) + " has different versions within the same stream");
        }
        if (node.isLeaf()) {
            this.finishReadingLeaf(directory, node.asLeaf(), classVersion);
        } else {
            this.finishReadingInternal(directory, node.asInternal(), classVersion);
        }
    }

    private static void validateDirectory(@NonNull Path directory) {
        Objects.requireNonNull(directory, "directory must not be null");
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory " + directory + " does not exist");
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("'directory' " + directory + " is not a directory");
        }
        if (!Files.isReadable(directory)) {
            throw new IllegalArgumentException("invalid read permissions for directory " + directory);
        }
    }

    public <T extends MerkleNode> T readMerkleTree(Path directory, int maxNumberOfNodes) throws IOException {
        boolean rootIsNull;
        MerkleDataInputStream.validateDirectory(directory);
        int merkleVersion = this.readInt();
        if (merkleVersion == 1) {
            throw new MerkleSerializationException("Unhandled merkle serialization version " + merkleVersion);
        }
        if (merkleVersion == 2) {
            this.readSerializable(false, MerkleTreeSerializationOptions::new);
        }
        if (rootIsNull = this.readBoolean()) {
            return null;
        }
        HashMap<Long, Integer> deserializedVersions = new HashMap<Long, Integer>();
        int nodeCount = 0;
        while (!this.internalNodes.isEmpty() || this.root == null) {
            if (++nodeCount > maxNumberOfNodes) {
                throw new MerkleSerializationException("Node count exceeds maximum value of " + maxNumberOfNodes + ".");
            }
            this.readNextNode(directory, deserializedVersions);
        }
        MerkleNode migratedRoot = MerkleInitialize.initializeAndMigrateTreeAfterDeserialization(this.root, deserializedVersions);
        if (migratedRoot == null) {
            return null;
        }
        return (T)migratedRoot.cast();
    }
}

