/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MerkleDataOutputStream
extends SerializableDataOutputStream {
    private static final Logger logger = LogManager.getLogger(MerkleDataOutputStream.class);
    private static final Predicate<MerkleInternal> DESCENDANT_FILTER = node -> !(node instanceof ExternalSelfSerializable);

    public MerkleDataOutputStream(OutputStream out) {
        super(out);
    }

    private void writeSerializableNode(Path directory, ExternalSelfSerializable node) throws IOException {
        this.writeClassIdVersion(node, true);
        node.serialize(this, directory);
    }

    private void writeDefaultInternalNode(MerkleInternal node) throws IOException {
        this.writeLong(node.getClassId());
        this.writeInt(node.getVersion());
        this.writeInt(node.getNumberOfChildren());
    }

    private void writeInternal(Path directory, MerkleInternal node) throws IOException {
        if (node instanceof ExternalSelfSerializable) {
            ExternalSelfSerializable externalSelfSerializable = (ExternalSelfSerializable)((Object)node);
            this.writeSerializableNode(directory, externalSelfSerializable);
        } else {
            this.writeDefaultInternalNode(node);
        }
    }

    private void writeLeaf(Path directory, MerkleLeaf node) throws IOException {
        this.writeSerializableNode(directory, node);
    }

    private void writeNull() throws IOException {
        this.writeSerializable(null, true);
    }

    private static void validateDirectory(Path directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory " + directory + " does not exist");
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("'directory' " + directory + " is not a directory");
        }
        if (!Files.isReadable(directory)) {
            throw new IllegalArgumentException("invalid read permissions for directory " + directory);
        }
        if (!Files.isWritable(directory)) {
            throw new IllegalArgumentException("invalid write permissions for directory " + directory);
        }
        try (Stream<Path> list = Files.list(directory);){
            List<Path> contents = list.toList();
            if (contents.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("merkle tree being written to directory ").append(directory).append(" that already contains data. Contents:");
                for (Path path : contents) {
                    sb.append("\n   ").append(path);
                }
                logger.info(LogMarker.STATE_TO_DISK.getMarker(), (CharSequence)sb);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeMerkleTree(Path directory, MerkleNode root) throws IOException {
        this.writeInt(3);
        this.writeBoolean(root == null);
        MerkleDataOutputStream.validateDirectory(directory);
        if (root == null) {
            return;
        }
        root.treeIterator().setOrder(MerkleIterationOrder.BREADTH_FIRST).setDescendantFilter(DESCENDANT_FILTER).ignoreNull(false).forEachRemainingWithIO(node -> {
            if (node == null) {
                this.writeNull();
            } else if (node.isLeaf()) {
                this.writeLeaf(directory, node.asLeaf());
            } else {
                this.writeInternal(directory, node.asInternal());
            }
        });
    }
}

