/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.utility;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.base.time.Time;
import com.swirlds.common.config.StateConfig;
import com.swirlds.common.io.config.RecycleBinConfig;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.metrics.IntegerGauge;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.locks.AutoClosableLock;
import com.swirlds.common.threading.locks.Locks;
import com.swirlds.common.threading.locks.locked.Locked;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.utility.CompareTo;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecycleBinImpl
implements RecycleBin,
Startable,
Stoppable {
    private static final Logger logger = LogManager.getLogger(RecycleBinImpl.class);
    private final Time time;
    private final Path recycleBinPath;
    private final Duration maximumFileAge;
    private int topLevelRecycledFileCount;
    private final StoppableThread cleanupThread;
    private final AutoClosableLock lock = Locks.createAutoLock();
    private static final IntegerGauge.Config RECYLED_FILE_COUNT_CONFIG = new IntegerGauge.Config("platform", "recycled-file-count").withDescription("The number of top level files/directories in the recycle bin, non recursive.");
    private final IntegerGauge recycledFileCountMetric;

    public RecycleBinImpl(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull ThreadManager threadManager, @NonNull Time time, @NonNull NodeId selfId) throws IOException {
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(threadManager);
        this.time = Objects.requireNonNull(time);
        RecycleBinConfig recycleBinConfig = (RecycleBinConfig)configuration.getConfigData(RecycleBinConfig.class);
        StateConfig stateConfig = (StateConfig)configuration.getConfigData(StateConfig.class);
        this.maximumFileAge = recycleBinConfig.maximumFileAge();
        this.recycleBinPath = recycleBinConfig.getStorageLocation(stateConfig, selfId);
        Files.createDirectories(this.recycleBinPath, new FileAttribute[0]);
        this.topLevelRecycledFileCount = RecycleBinImpl.countRecycledFiles(this.recycleBinPath);
        this.recycledFileCountMetric = metrics.getOrCreate(RECYLED_FILE_COUNT_CONFIG);
        this.recycledFileCountMetric.set(this.topLevelRecycledFileCount);
        this.cleanupThread = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(threadManager).setComponent("platform")).setThreadName("recycle-bin-cleanup")).setMinimumPeriod(recycleBinConfig.collectionPeriod())).setWork(this::cleanup)).build();
    }

    public void clear() throws IOException {
        try (Locked ignored = this.lock.lock();){
            FileUtils.deleteDirectory(this.recycleBinPath);
            Files.createDirectories(this.recycleBinPath, new FileAttribute[0]);
            this.topLevelRecycledFileCount = 0;
            this.recycledFileCountMetric.set(0);
        }
    }

    private static int countRecycledFiles(@NonNull Path recycleBinPath) {
        int n;
        block8: {
            Stream<Path> stream = Files.list(recycleBinPath);
            try {
                n = (int)stream.count();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Error counting recycle bin files", (Throwable)e);
                    return 0;
                }
            }
            stream.close();
        }
        return n;
    }

    @Override
    public void recycle(@NonNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            logger.warn(LogMarker.STARTUP.getMarker(), "Cannot recycle non-existent file: {}", (Object)path);
            return;
        }
        try (Locked ignored = this.lock.lock();){
            Path fileName = path.getFileName();
            Path recyclePath = this.recycleBinPath.resolve(fileName);
            if (Files.exists(recyclePath, new LinkOption[0])) {
                logger.info(LogMarker.STARTUP.getMarker(), "File with the name '{}' already exists in the recycle bin, deleting previous copy.", (Object)fileName);
                FileUtils.deleteDirectory(recyclePath);
            } else {
                ++this.topLevelRecycledFileCount;
                this.recycledFileCountMetric.set(this.topLevelRecycledFileCount);
            }
            Files.move(path, recyclePath, new CopyOption[0]);
        }
    }

    private void cleanup() {
        Instant now = this.time.now();
        AtomicInteger deletedCount = new AtomicInteger();
        try (Locked ignored = this.lock.lock();){
            try (Stream<Path> stream = Files.list(this.recycleBinPath);){
                stream.forEach(path -> {
                    try {
                        Instant lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                        Duration age = Duration.between(lastModified, now);
                        if (CompareTo.isGreaterThan(age, this.maximumFileAge)) {
                            FileUtils.deleteDirectory(path);
                            deletedCount.incrementAndGet();
                            --this.topLevelRecycledFileCount;
                        }
                    }
                    catch (IOException e) {
                        logger.error(LogMarker.EXCEPTION.getMarker(), "Error cleaning up recycle bin file {}", path, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Error cleaning up recycle bin", (Throwable)e);
            }
            this.recycledFileCountMetric.set(this.topLevelRecycledFileCount);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Deleted {} files from the recycle bin.", (Object)deletedCount.get());
    }

    public void start() {
        this.cleanupThread.start();
    }

    public void stop() {
        this.cleanupThread.stop();
    }
}

