/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.hash;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.hash.FutureMerkleHash;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.utility.MerkleConstants;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.futures.StandardFuture;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MerkleHashBuilder {
    private static final Logger logger = LogManager.getLogger(MerkleHashBuilder.class);
    private final Executor threadPool;
    private final int cpuThreadCount;
    private final MerkleCryptography merkleCryptography;
    private final Cryptography cryptography;

    public MerkleHashBuilder(ThreadManager threadManager, MerkleCryptography merkleCryptography, Cryptography cryptography, int cpuThreadCount) {
        this.merkleCryptography = merkleCryptography;
        this.cryptography = cryptography;
        this.cpuThreadCount = cpuThreadCount;
        ThreadFactory threadFactory = ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setDaemon(true)).setComponent("adv crypto")).setThreadName("merkle hash")).setPriority(5)).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception in MerkleHashBuilder thread pool", ex))).buildFactory();
        this.threadPool = Executors.newFixedThreadPool(cpuThreadCount, threadFactory);
    }

    private static boolean filter(MerkleNode node) {
        if (node == null) {
            return false;
        }
        if (node.isSelfHashing()) {
            return true;
        }
        return node.getHash() == null;
    }

    private static boolean descendantFilter(MerkleNode child) {
        if (child.isSelfHashing()) {
            return false;
        }
        return child.getHash() == null;
    }

    public Hash digestTreeSync(MerkleNode root) {
        if (root == null) {
            return this.cryptography.getNullHash(MerkleConstants.MERKLE_DIGEST_TYPE);
        }
        MerkleIterator<MerkleNode> iterator = root.treeIterator().setFilter(MerkleHashBuilder::filter).setDescendantFilter(MerkleHashBuilder::descendantFilter);
        this.hashSubtree(iterator, null);
        return root.getHash();
    }

    public Future<Hash> digestTreeAsync(MerkleNode root) {
        if (root == null) {
            return new StandardFuture<Hash>(this.cryptography.getNullHash(MerkleConstants.MERKLE_DIGEST_TYPE));
        }
        if (root.getHash() != null) {
            return new StandardFuture<Hash>(root.getHash());
        }
        FutureMerkleHash result = new FutureMerkleHash();
        AtomicInteger activeThreadCount = new AtomicInteger(this.cpuThreadCount);
        for (int threadIndex = 0; threadIndex < this.cpuThreadCount; ++threadIndex) {
            this.threadPool.execute(this.createHashingRunnable(threadIndex, activeThreadCount, result, root));
        }
        return result;
    }

    private Runnable createHashingRunnable(int threadId, AtomicInteger activeThreadCount, FutureMerkleHash result, MerkleNode root) {
        return () -> {
            MerkleIterator<MerkleNode> it = root.treeIterator().setFilter(MerkleHashBuilder::filter).setDescendantFilter(MerkleHashBuilder::descendantFilter);
            if (threadId > 0) {
                it.setOrder(MerkleIterationOrder.POST_ORDERED_DEPTH_FIRST_RANDOM);
            }
            try {
                this.hashSubtree(it, activeThreadCount);
                int remainingActiveThreads = activeThreadCount.getAndDecrement() - 1;
                if (remainingActiveThreads == 0) {
                    result.set(root.getHash());
                }
            }
            catch (Throwable t) {
                result.cancelWithException(t);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hashSubtree(Iterator<MerkleNode> it, AtomicInteger activeThreadCount) {
        while (it.hasNext()) {
            MerkleNode node;
            MerkleNode merkleNode = node = it.next();
            synchronized (merkleNode) {
                if (activeThreadCount != null && activeThreadCount.get() != this.cpuThreadCount) {
                    break;
                }
                if (node.getHash() != null) {
                    continue;
                }
                if (node.isLeaf()) {
                    this.merkleCryptography.digestSync(node.asLeaf(), MerkleConstants.MERKLE_DIGEST_TYPE);
                } else {
                    this.merkleCryptography.digestSync(node.asInternal(), MerkleConstants.MERKLE_DIGEST_TYPE);
                }
            }
        }
    }
}

