/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.proof;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.proof.SignatureVerifier;
import com.swirlds.common.merkle.proof.algorithms.NodeSignature;
import com.swirlds.common.merkle.proof.algorithms.StateProofSerialization;
import com.swirlds.common.merkle.proof.algorithms.StateProofTreeBuilder;
import com.swirlds.common.merkle.proof.algorithms.StateProofUtils;
import com.swirlds.common.merkle.proof.tree.StateProofNode;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.AddressBook;
import com.swirlds.common.utility.Threshold;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StateProof
implements SelfSerializable {
    private static final long CLASS_ID = -4657489490582556124L;
    private List<NodeSignature> signatures;
    private StateProofNode root;
    private List<MerkleLeaf> payloads;
    private byte[] hashBytes;

    public StateProof() {
    }

    public StateProof(@NonNull Cryptography cryptography, @NonNull MerkleNode merkleRoot, @NonNull Map<NodeId, Signature> signatures, @NonNull List<MerkleLeaf> payloads) {
        Objects.requireNonNull(cryptography);
        Objects.requireNonNull(merkleRoot);
        Objects.requireNonNull(signatures);
        Objects.requireNonNull(payloads);
        this.payloads = StateProofTreeBuilder.validatePayloads(payloads);
        this.signatures = StateProofTreeBuilder.processSignatures(signatures);
        this.root = StateProofTreeBuilder.buildStateProofTree(cryptography, merkleRoot, payloads);
    }

    public boolean isValid(@NonNull Cryptography cryptography, @NonNull AddressBook addressBook, @NonNull Threshold threshold) {
        return this.isValid(cryptography, addressBook, threshold, Signature::verifySignature);
    }

    public boolean isValid(@NonNull Cryptography cryptography, @NonNull AddressBook addressBook, @NonNull Threshold threshold, @NonNull SignatureVerifier signatureVerifier) {
        Objects.requireNonNull(cryptography);
        Objects.requireNonNull(addressBook);
        Objects.requireNonNull(threshold);
        Objects.requireNonNull(signatureVerifier);
        if (this.hashBytes == null) {
            this.hashBytes = StateProofUtils.computeStateProofTreeHash(cryptography, this.root);
        }
        long validWeight = StateProofUtils.computeValidSignatureWeight(addressBook, this.signatures, signatureVerifier, this.hashBytes);
        return threshold.isSatisfiedBy(validWeight, addressBook.getTotalWeight());
    }

    @NonNull
    public List<MerkleLeaf> getPayloads() {
        if (this.payloads == null) {
            throw new IllegalStateException("StateProof has not been fully deserialized");
        }
        return this.payloads;
    }

    @Override
    public long getClassId() {
        return -4657489490582556124L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        StateProofSerialization.serializeSignatures(out, this.signatures);
        StateProofSerialization.serializeStateProofTree(out, this.root);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.signatures = StateProofSerialization.deserializeSignatures(in);
        this.root = StateProofSerialization.deserializeStateProofTree(in);
        this.payloads = StateProofSerialization.extractPayloads(this.root);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

