/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.proof.tree;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.proof.algorithms.StateProofConstants;
import com.swirlds.common.merkle.proof.tree.AbstractStateProofNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;

public class StateProofOpaqueNode
extends AbstractStateProofNode
implements SelfSerializable {
    private static final long CLASS_ID = 5382790336368540605L;
    private byte[] data;

    public StateProofOpaqueNode() {
    }

    public StateProofOpaqueNode(@NonNull List<byte[]> byteSegments) {
        int totalSize = 0;
        for (byte[] segment : byteSegments) {
            totalSize += segment.length;
        }
        this.data = new byte[totalSize];
        int offset = 0;
        for (byte[] segment : byteSegments) {
            System.arraycopy(segment, 0, this.data, offset, segment.length);
            offset += segment.length;
        }
    }

    @Override
    public void computeHashableBytes(@NonNull Cryptography cryptography, @NonNull MessageDigest digest) {
        if (this.data == null) {
            throw new IllegalStateException("StateProofOpaqueData has not been properly initialized");
        }
        this.setHashableBytes(this.data);
    }

    @Override
    public long getClassId() {
        return 5382790336368540605L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        if (this.data.length > StateProofConstants.MAX_OPAQUE_DATA_SIZE) {
            throw new IllegalStateException("StateProofOpaqueData is too large to serialize");
        }
        out.writeByteArray(this.data);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.data = in.readByteArray(StateProofConstants.MAX_OPAQUE_DATA_SIZE);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

