/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.proof.tree;

import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.proof.tree.AbstractStateProofNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.MessageDigest;

public class StateProofPayload
extends AbstractStateProofNode
implements SelfSerializable {
    private static final long CLASS_ID = -3307769763825469673L;
    private MerkleLeaf payload;
    private boolean initialized = false;

    public StateProofPayload() {
    }

    public StateProofPayload(@Nullable MerkleLeaf payload) {
        if (payload != null && payload.getHash() == null) {
            throw new IllegalArgumentException("Payload must be hashed");
        }
        this.payload = payload;
        this.initialized = true;
    }

    @NonNull
    public MerkleLeaf getPayload() {
        return this.payload;
    }

    @Override
    public void computeHashableBytes(@NonNull Cryptography cryptography, @NonNull MessageDigest digest) {
        if (!this.initialized) {
            throw new IllegalStateException("StateProofPayload has not been properly initialized");
        }
        if (this.payload.getHash() == null) {
            cryptography.digestSync(this.payload);
        }
        this.setHashableBytes(this.payload.getHash().getValue());
    }

    @Override
    public long getClassId() {
        return -3307769763825469673L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        out.writeSerializable(this.payload, true);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.payload = (MerkleLeaf)in.readSerializable();
        this.initialized = true;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

